/*
 * Decompiled with CFR 0.152.
 */
package lpv;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import lpv.ErrorMetric;
import org.jfree.data.category.DefaultCategoryDataset;

public class ErrorStore
extends Observable {
    private List<String> sources = new ArrayList<String>();
    private HashMap<String, List<ErrorMetric>> store = new HashMap();

    public void registerSource(String name) {
        this.sources.add(name);
        this.store.put(name, new ArrayList());
    }

    public void add(String name, ErrorMetric error) {
        this.store.get(name).add(error);
        this.setChanged();
        this.notifyObservers();
    }

    public void dump() {
        for (String source : this.sources) {
            StringBuilder[] sb = new StringBuilder[]{new StringBuilder(String.format("%20s = [ ", source + "AAE")), new StringBuilder(String.format("%20s = [ ", source + "ARE")), new StringBuilder(String.format("%20s = [ ", source + "MAE")), new StringBuilder(String.format("%20s = [ ", source + "MRE")), new StringBuilder(String.format("%20s = [ ", source + "CAE"))};
            Iterator<ErrorMetric> it = this.store.get(source).iterator();
            while (it.hasNext()) {
                ErrorMetric n = it.next();
                sb[0].append(String.format("%12.6f", Float.valueOf(n.averageAbsoluteError)));
                sb[1].append(String.format("%12.6f", Float.valueOf(n.averageRelativeError)));
                sb[2].append(String.format("%12.6f", Float.valueOf(n.maxAbsoluteError)));
                sb[3].append(String.format("%12.6f", Float.valueOf(n.maxRelativeError)));
                sb[4].append(String.format("%12.6f", Float.valueOf(n.cumulativeAbsoluteError)));
                if (!it.hasNext()) continue;
                for (int i = 0; i < sb.length; ++i) {
                    sb[i].append(", ");
                }
            }
            for (int i = 0; i < sb.length; ++i) {
                sb[i].append("];");
                System.out.println(sb[i].toString());
            }
            System.out.println();
        }
    }

    public void getData(DefaultCategoryDataset dataset, String source, Set<Type> types) {
        dataset.clear();
        int i = 1;
        for (ErrorMetric n : this.store.get(source)) {
            if (types.contains((Object)Type.aae)) {
                dataset.addValue(n.averageAbsoluteError, (Comparable)((Object)"Avg. abs. error"), (Comparable)Integer.valueOf(i));
            }
            if (types.contains((Object)Type.are)) {
                dataset.addValue(n.averageRelativeError, (Comparable)((Object)"Avg. rel. error"), (Comparable)Integer.valueOf(i));
            }
            if (types.contains((Object)Type.mae)) {
                dataset.addValue(n.maxAbsoluteError, (Comparable)((Object)"Max abs. error"), (Comparable)Integer.valueOf(i));
            }
            if (types.contains((Object)Type.mre)) {
                dataset.addValue(n.maxRelativeError, (Comparable)((Object)"Max rel. error"), (Comparable)Integer.valueOf(i));
            }
            if (types.contains((Object)Type.cae)) {
                dataset.addValue(n.cumulativeAbsoluteError, (Comparable)((Object)"Cumulative error"), (Comparable)Integer.valueOf(i));
            }
            ++i;
        }
    }

    public List<String> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public void clear() {
        for (List<ErrorMetric> list : this.store.values()) {
            list.clear();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void load(String name, InputStream in) throws IOException {
        String[] line;
        if (!this.sources.contains(name)) {
            this.registerSource(name);
        }
        List<ErrorMetric> data = this.store.get(name);
        data.clear();
        CSVReader r = new CSVReader(new InputStreamReader(in));
        while ((line = r.readNext()) != null) {
            ErrorMetric em = new ErrorMetric();
            em.averageAbsoluteError = Float.parseFloat(line[0]);
            em.averageRelativeError = Float.parseFloat(line[1]);
            em.maxAbsoluteError = Float.parseFloat(line[2]);
            em.maxRelativeError = Float.parseFloat(line[3]);
            em.cumulativeAbsoluteError = Float.parseFloat(line[4]);
            data.add(em);
        }
        r.close();
        this.setChanged();
        this.notifyObservers();
    }

    public void save(String name, OutputStream out) throws IOException {
        List<ErrorMetric> data = this.store.get(name);
        CSVWriter w = new CSVWriter(new OutputStreamWriter(out));
        for (ErrorMetric em : data) {
            String aae = String.valueOf(em.averageAbsoluteError);
            String are = String.valueOf(em.averageRelativeError);
            String mae = String.valueOf(em.maxAbsoluteError);
            String mre = String.valueOf(em.maxRelativeError);
            String cae = String.valueOf(em.cumulativeAbsoluteError);
            w.writeNext(new String[]{aae, are, mae, mre, cae});
        }
        w.close();
    }

    public static enum Type {
        aae,
        are,
        mae,
        mre,
        cae;

    }
}

