/*
 * Decompiled with CFR 0.152.
 */
package lpv;

import javax.vecmath.Vector4f;

public class Volume {
    private Vector4f[][][] lpv;
    private int w;
    private int h;
    private int d;

    public Volume(int w, int h, int d) {
        this.lpv = new Vector4f[d][h][w];
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < h; ++j) {
                for (int k = 0; k < w; ++k) {
                    this.lpv[i][j][k] = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
        }
        this.w = w;
        this.h = h;
        this.d = d;
    }

    public Vector4f get(int x, int y, int z) {
        x = this.clamp(x, 0, this.w - 1);
        y = this.clamp(y, 0, this.h - 1);
        z = this.clamp(z, 0, this.d - 1);
        return this.lpv[z][y][x];
    }

    private int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void clear() {
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    this.lpv[i][j][k].set(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
        }
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getDepth() {
        return this.d;
    }

    public Vector4f getMax() {
        Vector4f max = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        float maxLenSq = 0.0f;
        for (int i = 0; i < this.d; ++i) {
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    float tmpLenSq = this.lpv[i][j][k].x * this.lpv[i][j][k].x + this.lpv[i][j][k].y * this.lpv[i][j][k].y;
                    if (!(tmpLenSq > maxLenSq)) continue;
                    maxLenSq = tmpLenSq;
                    max.set(this.lpv[i][j][k]);
                }
            }
        }
        return max;
    }
}

