/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lpv.gui.ErrorDialog;
import lpv.gui.FloatValidator;
import lpv.gui.InjectorDialog;
import lpv.gui.IntegerValidator;
import lpv.gui.PropagatorType;
import lpv.gui.ScaleManager;
import lpv.simulation.DefaultSimulation;
import lpv.simulation.GeometryInjectionStep;
import lpv.simulation.LightInjectionStep;
import lpv.simulation.SimulationStep;
import lpv.simulation.SimulationThread;
import lpv.simulation.injector.Injector;
import lpv.simulation.injector.WallInjector;
import lpv.simulation.propagator.AndreasKirschPropagator;
import lpv.simulation.propagator.BenjaminThautPropagator;
import lpv.simulation.propagator.CrytekSiggraphPropagator;
import lpv.simulation.propagator.ExperimentalPropagator;
import lpv.simulation.propagator.LeeSalzmanPropagator;
import lpv.simulation.propagator.NvidiaPropagator;
import lpv.simulation.propagator.Propagator;
import lpv.simulation.propagator.RafalWrobelPropagator;
import lpv.simulation.propagator.SSLPVPropagator;
import lpv.simulator.Simulator;

public class ControlPanel
extends JPanel {
    private static final int INITIAL_SCALE_VALUE = 50;
    private static final float DEFAULT_PROPAGATION_FACTOR = 4.0f;
    private static final int DEFAULT_ITERATIONS = 16;
    private static final int DEFAULT_SLOW_DELAY = 100;
    private Simulator simulator;
    private JTextField propagationFactorField;
    private JButton injectButton;
    private JButton propagateRightButton;
    private JButton clearAllButton;
    private JButton runButton;
    private JButton runSlowMotionButton;
    private JList injectorList;
    private JButton addInjectorButton;
    private JButton removeInjectorButton;
    private DefaultListModel injectorListModel;
    private JTextField iterationsField;
    private JTextField slowDelayField;
    private JComboBox propagatorComboBox;
    private JTextField propagatorUrlField;
    private JSlider scaleSlider;
    private ScaleManager scale;
    private JLabel scaleLabel;
    private JCheckBox autoScaleCheckBox;
    private DefaultListModel blockerListModel;
    private JList blockerList;
    private JButton addBlockerButton;
    private JButton removeBlockerButton;
    private JSlider levelSlider;
    private JButton downsampleButton;
    protected ErrorDialog errorDialog;

    public ControlPanel(final JFrame owner, final Simulator simulator, final ScaleManager scale) {
        this.simulator = simulator;
        this.scale = scale;
        this.errorDialog = null;
        this.setLayout(new BorderLayout());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new GridLayout(2, 1));
        JPanel injectorPanel = new JPanel();
        injectorPanel.setLayout(new BorderLayout());
        injectorPanel.add((Component)new JLabel("Injectors:"), "North");
        this.injectorListModel = new DefaultListModel();
        this.injectorList = new JList(this.injectorListModel);
        this.injectorListModel.addElement(new WallInjector.Left(0, 1.0f));
        JScrollPane jsp = new JScrollPane(this.injectorList);
        injectorPanel.add((Component)jsp, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.addInjectorButton = new JButton("Add");
        buttonPanel.add(this.addInjectorButton);
        this.removeInjectorButton = new JButton("Remove");
        buttonPanel.add(this.removeInjectorButton);
        injectorPanel.add((Component)buttonPanel, "South");
        this.addInjectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InjectorDialog injectorDialog = new InjectorDialog(owner);
                injectorDialog.setVisible(true);
                if (injectorDialog.getInjector() != null) {
                    ControlPanel.this.injectorListModel.addElement(injectorDialog.getInjector());
                }
            }
        });
        this.removeInjectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selected = ControlPanel.this.injectorList.getSelectedIndices();
                for (int i = selected.length - 1; i >= 0; --i) {
                    ControlPanel.this.injectorListModel.remove(selected[i]);
                }
            }
        });
        listPanel.add(injectorPanel);
        JPanel blockerPanel = new JPanel();
        blockerPanel.setLayout(new BorderLayout());
        blockerPanel.add((Component)new JLabel("Blockers:"), "North");
        this.blockerListModel = new DefaultListModel();
        this.blockerList = new JList(this.blockerListModel);
        jsp = new JScrollPane(this.blockerList);
        blockerPanel.add((Component)jsp, "Center");
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.addBlockerButton = new JButton("Add");
        buttonPanel.add(this.addBlockerButton);
        this.removeBlockerButton = new JButton("Remove");
        buttonPanel.add(this.removeBlockerButton);
        blockerPanel.add((Component)buttonPanel, "South");
        this.addBlockerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InjectorDialog blockerDialog = new InjectorDialog(owner);
                blockerDialog.setVisible(true);
                if (blockerDialog.getInjector() != null) {
                    ControlPanel.this.blockerListModel.addElement(blockerDialog.getInjector());
                }
            }
        });
        this.removeBlockerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selected = ControlPanel.this.blockerList.getSelectedIndices();
                for (int i = selected.length - 1; i >= 0; --i) {
                    ControlPanel.this.blockerListModel.remove(selected[i]);
                }
            }
        });
        listPanel.add(blockerPanel);
        this.add((Component)listPanel, "West");
        JPanel simulatorPanel = new JPanel();
        simulatorPanel.setLayout(new GridLayout(13, 2, 5, 5));
        simulatorPanel.add(new JLabel("Octree level:"));
        this.levelSlider = new JSlider(0, 0, simulator.getAccumulation().getLevels() - 1, 0);
        simulatorPanel.add(this.levelSlider);
        this.levelSlider.setMajorTickSpacing(1);
        this.levelSlider.setMinorTickSpacing(1);
        this.levelSlider.setSnapToTicks(true);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int val = ControlPanel.this.levelSlider.getValue();
                simulator.setLevel(val);
            }
        });
        this.levelSlider.setValue(0);
        simulatorPanel.add(new JLabel("Rendering amplifier: (2^x)"));
        this.scaleSlider = new JSlider(0, -200, 200, 0);
        simulatorPanel.add(this.scaleSlider);
        this.autoScaleCheckBox = new JCheckBox("Automatic scale", true);
        simulatorPanel.add(this.autoScaleCheckBox);
        this.scaleLabel = new JLabel("");
        simulatorPanel.add(this.scaleLabel);
        this.scaleSlider.setMajorTickSpacing(50);
        this.scaleSlider.setMinorTickSpacing(10);
        this.scaleSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(-200, new JLabel("Small"));
        labels.put(200, new JLabel("Large"));
        this.scaleSlider.setLabelTable(labels);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int val = ControlPanel.this.scaleSlider.getValue();
                float scaleValue = (float)Math.pow(2.0, (float)val / 10.0f);
                scale.setScale(scaleValue);
                ControlPanel.this.scaleLabel.setText("2^" + (float)val / 10.0f + " = " + scaleValue);
            }
        });
        this.scaleSlider.setValue(50);
        simulatorPanel.add(new JLabel("Propagator algorithm:"));
        this.propagatorComboBox = new JComboBox<PropagatorType>(PropagatorType.values());
        simulatorPanel.add(this.propagatorComboBox);
        this.propagatorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanel.this.propagatorUrlField.setText(((PropagatorType)((Object)ControlPanel.this.propagatorComboBox.getSelectedItem())).getUrl());
                ControlPanel.this.propagationFactorField.setEnabled(((PropagatorType)((Object)ControlPanel.this.propagatorComboBox.getSelectedItem())).supportsFactor());
            }
        });
        simulatorPanel.add(new JLabel("Propagator url:"));
        this.propagatorUrlField = new JTextField(PropagatorType.values()[0].getUrl(), 15);
        simulatorPanel.add(this.propagatorUrlField);
        this.propagatorUrlField.setEditable(false);
        simulatorPanel.add(new JLabel("Propagation factor:"));
        this.propagationFactorField = new JTextField(String.valueOf(4.0f));
        simulatorPanel.add(this.propagationFactorField);
        this.propagationFactorField.getDocument().addDocumentListener(new FloatValidator(this.propagationFactorField));
        this.injectButton = new JButton("Inject");
        simulatorPanel.add(this.injectButton);
        this.injectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new GeometryInjectionStep(ControlPanel.this.getGeometryInjectors()).run(simulator);
                new LightInjectionStep(ControlPanel.this.getLightInjectors()).run(simulator);
            }
        });
        this.propagateRightButton = new JButton("Propagate");
        simulatorPanel.add(this.propagateRightButton);
        this.propagateRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                simulator.propagate(ControlPanel.this.getPropagator());
                simulator.flip();
            }
        });
        this.clearAllButton = new JButton("Clear");
        simulatorPanel.add(this.clearAllButton);
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                simulator.clear();
            }
        });
        this.downsampleButton = new JButton("Downsample");
        simulatorPanel.add(this.downsampleButton);
        this.downsampleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                simulator.downsample();
            }
        });
        JButton errorSampleButton = new JButton("Sample errors");
        simulatorPanel.add(errorSampleButton);
        errorSampleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                simulator.sampleErrors();
            }
        });
        JButton errorPlotButton = new JButton("Plot errors");
        simulatorPanel.add(errorPlotButton);
        errorPlotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ControlPanel.this.errorDialog == null) {
                    ControlPanel.this.errorDialog = new ErrorDialog(simulator.getErrors());
                }
                if (ControlPanel.this.errorDialog.isVisible()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ControlPanel.this.errorDialog.requestFocus();
                        }
                    });
                }
                ControlPanel.this.errorDialog.setVisible(true);
            }
        });
        simulatorPanel.add(new JLabel());
        simulatorPanel.add(new JLabel());
        simulatorPanel.add(new JLabel("Iterations:"));
        this.iterationsField = new JTextField(String.valueOf(16));
        simulatorPanel.add(this.iterationsField);
        this.iterationsField.getDocument().addDocumentListener(new IntegerValidator(this.iterationsField));
        simulatorPanel.add(new JLabel("Slow delay (ms):"));
        this.slowDelayField = new JTextField(String.valueOf(100));
        simulatorPanel.add(this.slowDelayField);
        this.slowDelayField.getDocument().addDocumentListener(new IntegerValidator(this.slowDelayField));
        this.runButton = new JButton("Run");
        simulatorPanel.add(this.runButton);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DefaultSimulation simulation = new DefaultSimulation(ControlPanel.this.getIterations());
                simulation.addLightInjectors(ControlPanel.this.getLightInjectors());
                simulation.addGeometryInjectors(ControlPanel.this.getGeometryInjectors());
                simulation.setPropagator(ControlPanel.this.getPropagator());
                for (SimulationStep step : simulation) {
                    step.run(simulator);
                }
            }
        });
        this.runSlowMotionButton = new JButton("Run Slow");
        simulatorPanel.add(this.runSlowMotionButton);
        this.runSlowMotionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ControlPanel.this.setUIEnabled(false);
                DefaultSimulation simulation = new DefaultSimulation(ControlPanel.this.getIterations());
                simulation.addLightInjectors(ControlPanel.this.getLightInjectors());
                simulation.addGeometryInjectors(ControlPanel.this.getGeometryInjectors());
                simulation.setPropagator(ControlPanel.this.getPropagator());
                SimulationThread simulationThread = new SimulationThread(simulator, simulation, ControlPanel.this.getSlowDelay());
                simulationThread.addCompletionHandler(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ControlPanel.this.setUIEnabled(true);
                            }
                        });
                    }
                });
                simulationThread.start();
            }
        });
        JPanel tmp = new JPanel();
        tmp.setLayout(new FlowLayout(0));
        tmp.add(simulatorPanel);
        this.add((Component)tmp, "Center");
    }

    private void setUIEnabled(boolean enabled) {
        this.injectButton.setEnabled(enabled);
        this.propagateRightButton.setEnabled(enabled);
        this.clearAllButton.setEnabled(enabled);
        this.runButton.setEnabled(enabled);
        this.runSlowMotionButton.setEnabled(enabled);
        this.propagationFactorField.setEnabled(enabled);
        this.injectorList.setEnabled(enabled);
        this.addInjectorButton.setEnabled(enabled);
        this.removeInjectorButton.setEnabled(enabled);
        this.iterationsField.setEnabled(enabled);
        this.slowDelayField.setEnabled(enabled);
        this.propagatorComboBox.setEnabled(enabled);
    }

    protected List<Injector> getGeometryInjectors() {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        for (Object o : this.blockerListModel.toArray()) {
            injectors.add((Injector)o);
        }
        return injectors;
    }

    private List<Injector> getLightInjectors() {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        for (Object o : this.injectorListModel.toArray()) {
            injectors.add((Injector)o);
        }
        return injectors;
    }

    private int getIterations() {
        int iterations = Integer.parseInt(this.iterationsField.getText());
        if (iterations < 0) {
            throw new NumberFormatException("Negative values are not supported for string: " + this.iterationsField.getText());
        }
        return iterations;
    }

    private int getSlowDelay() {
        int delay = Integer.parseInt(this.slowDelayField.getText());
        if (delay < 0) {
            throw new NumberFormatException("Negative values are not supported for string: " + this.slowDelayField.getText());
        }
        return delay;
    }

    private Propagator getPropagator() {
        PropagatorType type = (PropagatorType)((Object)this.propagatorComboBox.getSelectedItem());
        float factor = Float.parseFloat(this.propagationFactorField.getText());
        switch (type) {
            case nvidia_nocopy: {
                return new NvidiaPropagator(factor, false);
            }
            case nvidia_copy: {
                return new NvidiaPropagator(factor, true);
            }
            case experimental: {
                return new ExperimentalPropagator(factor);
            }
            case lee_salzman: {
                return new LeeSalzmanPropagator(factor);
            }
            case benjamin_thaut: {
                return new BenjaminThautPropagator(factor);
            }
            case rafal_wrobel: {
                return new RafalWrobelPropagator();
            }
            case sslpv: {
                return new SSLPVPropagator(factor);
            }
            case andreas_kirsch: {
                return new AndreasKirschPropagator();
            }
            case crytek_siggraph: {
                return new CrytekSiggraphPropagator(factor);
            }
        }
        return null;
    }

    public void proposeScale(float scale) {
        if (this.autoScaleCheckBox.isSelected()) {
            float scaleLog2 = (float)(Math.log(scale) / Math.log(2.0));
            int scaleValue = (int)(scaleLog2 * 10.0f);
            this.scaleSlider.setValue(scaleValue);
        }
    }
}

