/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import lpv.ErrorStore;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class ErrorDialog
extends JDialog
implements Observer {
    private HashMap<String, DefaultCategoryDataset> datasets;
    private JCheckBox aaeBox;
    private JCheckBox areBox;
    private JCheckBox maeBox;
    private JCheckBox mreBox;
    private JCheckBox caeBox;
    private ErrorStore errors;
    private JButton saveImageButton;
    private JTabbedPane tabs;
    private JButton exportDataButton;
    private JButton importDataButton;

    public ErrorDialog(ErrorStore errors) {
        super((Frame)null, "Error plot", false);
        this.errors = errors;
        errors.addObserver(this);
        this.datasets = new HashMap();
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        JPanel controlPanel = new JPanel();
        JPanel innerControlPanel = new JPanel();
        innerControlPanel.setLayout(new BoxLayout(innerControlPanel, 1));
        ActionListener checkBoxHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ErrorDialog.this.updateDatasets();
            }
        };
        this.aaeBox = new JCheckBox("Average absolute error", true);
        innerControlPanel.add(this.aaeBox);
        this.aaeBox.addActionListener(checkBoxHandler);
        this.areBox = new JCheckBox("Average relative error", true);
        innerControlPanel.add(this.areBox);
        this.areBox.addActionListener(checkBoxHandler);
        this.maeBox = new JCheckBox("Max absolute error", true);
        innerControlPanel.add(this.maeBox);
        this.maeBox.addActionListener(checkBoxHandler);
        this.mreBox = new JCheckBox("Max relative error", true);
        innerControlPanel.add(this.mreBox);
        this.mreBox.addActionListener(checkBoxHandler);
        this.caeBox = new JCheckBox("Cumulative absolute error", true);
        innerControlPanel.add(this.caeBox);
        this.caeBox.addActionListener(checkBoxHandler);
        this.saveImageButton = new JButton("Save image...");
        innerControlPanel.add(this.saveImageButton);
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ErrorDialog.this.showSaveImageDialog();
            }
        });
        this.exportDataButton = new JButton("Export data...");
        innerControlPanel.add(this.exportDataButton);
        this.exportDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ErrorDialog.this.showExportDataDialog();
            }
        });
        this.importDataButton = new JButton("Import data...");
        innerControlPanel.add(this.importDataButton);
        this.importDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ErrorDialog.this.showImportDataDialog();
            }
        });
        controlPanel.add(innerControlPanel);
        this.add((Component)controlPanel, "West");
        this.tabs = new JTabbedPane();
        for (String source : errors.getSources()) {
            this.createDataset(source);
        }
        this.add((Component)this.tabs, "Center");
        this.pack();
        this.updateDatasets();
    }

    private void createDataset(String source) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.datasets.put(source, dataset);
        JFreeChart chart = ChartFactory.createLineChart(source + " error plot", "Sample point", "Error", dataset, PlotOrientation.VERTICAL, true, true, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(640, 480));
        this.tabs.addTab(source, chartPanel);
    }

    private void updateDatasets() {
        EnumSet<ErrorStore.Type> types = EnumSet.noneOf(ErrorStore.Type.class);
        if (this.aaeBox.isSelected()) {
            types.add(ErrorStore.Type.aae);
        }
        if (this.areBox.isSelected()) {
            types.add(ErrorStore.Type.are);
        }
        if (this.maeBox.isSelected()) {
            types.add(ErrorStore.Type.mae);
        }
        if (this.mreBox.isSelected()) {
            types.add(ErrorStore.Type.mre);
        }
        if (this.caeBox.isSelected()) {
            types.add(ErrorStore.Type.cae);
        }
        for (Map.Entry<String, DefaultCategoryDataset> datasetEntry : this.datasets.entrySet()) {
            this.errors.getData(datasetEntry.getValue(), datasetEntry.getKey(), types);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateDatasets();
    }

    private void showSaveImageDialog() {
        Preferences pref = Preferences.userNodeForPackage(ErrorDialog.class);
        File old = new File(pref.get("error.save.path", ""));
        JFileChooser fileChooser = old.exists() ? new JFileChooser(old) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(ImageFileFilter.BMP);
        fileChooser.addChoosableFileFilter(ImageFileFilter.EPS);
        fileChooser.addChoosableFileFilter(ImageFileFilter.JPEG);
        fileChooser.addChoosableFileFilter(ImageFileFilter.PNG);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            File file = fileChooser.getSelectedFile();
            pref.put("error.save.path", file.getAbsolutePath());
            ChartPanel currentChartPanel = (ChartPanel)this.tabs.getSelectedComponent();
            if (currentChartPanel != null) {
                int option;
                boolean proceed = true;
                if (file.exists() && (option = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists. \nDo you want to replace it?", "Replace file", 0)) != 0) {
                    proceed = false;
                }
                if (proceed) {
                    ImageFileFilter filter = (ImageFileFilter)fileChooser.getFileFilter();
                    if (filter == ImageFileFilter.EPS) {
                        try {
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                            EpsGraphics g = new EpsGraphics(currentChartPanel.getChart().getTitle().getText(), out, 0, 0, 640, 480, ColorMode.COLOR_RGB);
                            currentChartPanel.getChart().draw(g, new Rectangle2D.Double(0.0, 0.0, 640.0, 480.0));
                            g.flush();
                            ((OutputStream)out).flush();
                            ((OutputStream)out).close();
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(this, "Could not save file. " + e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        BufferedImage img = currentChartPanel.getChart().createBufferedImage(1280, 720);
                        try {
                            if (!ImageIO.write((RenderedImage)img, filter.getFormatName(), file)) {
                                JOptionPane.showMessageDialog(this, "Could not save file. No appropriate writer could be found for " + filter.getFormatName() + ".");
                            }
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(this, "Could not save file. " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
            }
        } else {
            pref.put("error.save.path", fileChooser.getCurrentDirectory().getAbsolutePath());
        }
    }

    private void showExportDataDialog() {
        Preferences pref = Preferences.userNodeForPackage(ErrorDialog.class);
        File old = new File(pref.get("error.path", ""));
        JFileChooser fileChooser = old.exists() ? new JFileChooser(old) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isFile() || pathname.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "Comma separated vector (*.csv)";
            }
        });
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            int option;
            File file = fileChooser.getSelectedFile();
            pref.put("error.path", file.getAbsolutePath());
            boolean proceed = true;
            if (file.exists() && (option = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists. \nDo you want to replace it?", "Replace file", 0)) != 0) {
                proceed = false;
            }
            if (proceed) {
                try {
                    FileOutputStream fout = new FileOutputStream(file);
                    int index = this.tabs.getSelectedIndex();
                    if (index != -1) {
                        this.errors.save(this.tabs.getTitleAt(index), fout);
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Could not save file. " + e.getMessage());
                    e.printStackTrace();
                }
            }
        } else {
            pref.put("error.path", fileChooser.getCurrentDirectory().getAbsolutePath());
        }
    }

    private void showImportDataDialog() {
        Preferences pref = Preferences.userNodeForPackage(ErrorDialog.class);
        File old = new File(pref.get("error.path", ""));
        JFileChooser fileChooser = old.exists() ? new JFileChooser(old) : new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isFile() || pathname.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "Comma separated vector (*.csv)";
            }
        });
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            File[] files;
            File file = fileChooser.getSelectedFile();
            pref.put("error.path", file.getAbsolutePath());
            for (File f : files = fileChooser.getSelectedFiles()) {
                try {
                    FileInputStream fin = new FileInputStream(f);
                    this.errors.load(f.getName(), fin);
                    if (this.datasets.containsKey(f.getName())) continue;
                    this.createDataset(f.getName());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Could not load file " + f.getName() + ". " + e.getMessage());
                    e.printStackTrace();
                    break;
                }
            }
            this.updateDatasets();
        } else {
            pref.put("error.path", fileChooser.getCurrentDirectory().getAbsolutePath());
        }
    }

    private static class ImageFileFilter
    extends FileFilter {
        public static ImageFileFilter PNG = new ImageFileFilter("PNG", ".png", "Portable Network Graphics (*.png)");
        public static ImageFileFilter BMP = new ImageFileFilter("BMP", ".bmp", "Bitmap Image File (*.bmp)");
        public static ImageFileFilter JPEG = new ImageFileFilter("JPEG", ".jpg", "Joint Photographic Experts Group (*.jpg)");
        public static ImageFileFilter EPS = new ImageFileFilter("EPS", ".eps", "Encapsulated PostScript (*.eps)");
        private String formatName;
        private String extension;
        private String description;

        private ImageFileFilter(String formatName, String extension, String description) {
            this.formatName = formatName;
            this.extension = extension;
            this.description = description;
        }

        public String getFormatName() {
            return this.formatName;
        }

        public String getExtension() {
            return this.extension;
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.isFile() || pathname.getName().endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

