/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import lpv.gui.card.InjectorCard;
import lpv.gui.card.InjectorType;
import lpv.simulation.injector.Injector;

public class InjectorDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private Injector injector = null;
    protected InjectorCard currentInjectorCard;

    public InjectorDialog(JFrame owner) {
        super(owner, "Add injector", true);
        this.setLayout(new BorderLayout());
        final JPanel cardPanel = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        cardPanel.setLayout(cardLayout);
        this.add((Component)cardPanel, "Center");
        JPanel typePanel = new JPanel();
        ButtonGroup typeGroup = new ButtonGroup();
        boolean first = true;
        typePanel.setLayout(new GridLayout(1, InjectorType.values().length));
        for (final InjectorType type : InjectorType.values()) {
            InjectorCard card;
            JRadioButton button = new JRadioButton(type.name, first);
            typePanel.add(button);
            typeGroup.add(button);
            try {
                card = type.cardClass.newInstance();
                cardPanel.add((Component)card, type.name());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cardLayout.show(cardPanel, type.name());
                    InjectorDialog.this.currentInjectorCard = card;
                }
            });
            if (first) {
                cardLayout.show(cardPanel, type.name());
                this.currentInjectorCard = card;
            }
            first = false;
        }
        this.add((Component)typePanel, "North");
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("Ok");
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (InjectorDialog.this.createInjector()) {
                    InjectorDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InjectorDialog.this.setVisible(false);
            }
        });
        this.add((Component)buttonPanel, "South");
        this.pack();
    }

    private boolean createInjector() {
        return this.currentInjectorCard != null && (this.injector = this.currentInjectorCard.createInjector()) != null;
    }

    public Injector getInjector() {
        return this.injector;
    }
}

