/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LPVSizeDialog
extends JDialog {
    private JSlider widthSlider;
    private JSlider heightSlider;
    private JSlider depthSlider;
    private JLabel widthLabel;
    private JLabel heightLabel;
    private JLabel depthLabel;
    private JButton okButton;
    private JButton cancelButton;
    protected boolean submitted = false;
    protected int width = 0;
    protected int height = 0;
    protected int depth = 0;

    public LPVSizeDialog() {
        super((Frame)null, "Light propagation volume size", true);
        this.setLayout(new BorderLayout());
        final Preferences pref = Preferences.userNodeForPackage(LPVSizeDialog.class);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new GridLayout(3, 3, 5, 5));
        this.widthLabel = new JLabel("Width: " + pref.getInt("lpv.width", 16));
        sizePanel.add(this.widthLabel);
        this.heightLabel = new JLabel("Height: " + pref.getInt("lpv.height", 16));
        sizePanel.add(this.heightLabel);
        this.depthLabel = new JLabel("Depth: " + pref.getInt("lpv.depth", 16));
        sizePanel.add(this.depthLabel);
        this.widthSlider = new JSlider(0, 0, 64, pref.getInt("lpv.width", 16));
        sizePanel.add(this.widthSlider);
        this.widthSlider.setMajorTickSpacing(16);
        this.widthSlider.setMinorTickSpacing(2);
        this.widthSlider.setPaintLabels(true);
        this.widthSlider.setPaintTicks(true);
        this.widthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                LPVSizeDialog.this.widthLabel.setText("Width: " + Math.max(1, LPVSizeDialog.this.widthSlider.getValue()));
            }
        });
        this.heightSlider = new JSlider(0, 0, 64, pref.getInt("lpv.height", 16));
        sizePanel.add(this.heightSlider);
        this.heightSlider.setMajorTickSpacing(16);
        this.heightSlider.setMinorTickSpacing(2);
        this.heightSlider.setPaintLabels(true);
        this.heightSlider.setPaintTicks(true);
        this.heightSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                LPVSizeDialog.this.heightLabel.setText("Height: " + Math.max(1, LPVSizeDialog.this.heightSlider.getValue()));
            }
        });
        this.depthSlider = new JSlider(0, 0, 64, pref.getInt("lpv.depth", 16));
        sizePanel.add(this.depthSlider);
        this.depthSlider.setMajorTickSpacing(16);
        this.depthSlider.setMinorTickSpacing(2);
        this.depthSlider.setPaintLabels(true);
        this.depthSlider.setPaintTicks(true);
        this.depthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                LPVSizeDialog.this.depthLabel.setText("Depth: " + Math.max(1, LPVSizeDialog.this.depthSlider.getValue()));
            }
        });
        sizePanel.add(new JLabel());
        sizePanel.add(new JLabel());
        sizePanel.add(new JLabel("<html>Note: Depth is not directly <br />visible in the simulator.</html>"));
        this.add((Component)sizePanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("Ok");
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LPVSizeDialog.this.submitted = true;
                LPVSizeDialog.this.width = Math.max(1, LPVSizeDialog.this.widthSlider.getValue());
                LPVSizeDialog.this.height = Math.max(1, LPVSizeDialog.this.heightSlider.getValue());
                LPVSizeDialog.this.depth = Math.max(1, LPVSizeDialog.this.depthSlider.getValue());
                pref.putInt("lpv.width", LPVSizeDialog.this.width);
                pref.putInt("lpv.height", LPVSizeDialog.this.height);
                pref.putInt("lpv.depth", LPVSizeDialog.this.depth);
                LPVSizeDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LPVSizeDialog.this.submitted = false;
                LPVSizeDialog.this.setVisible(false);
            }
        });
        this.add((Component)buttonPanel, "South");
        this.pack();
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public int getSubmittedWidth() {
        return this.width;
    }

    public int getSubmittedHeight() {
        return this.height;
    }

    public int getSubmittedDepth() {
        return this.depth;
    }
}

