/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.SH;
import lpv.gui.ScaleManager;
import lpv.gui.StatusBar;

public class LPVVisualizer
extends JPanel
implements Observer {
    private static final int SH_RESOLUTION = 16;
    private LPV lpv;
    private ScaleManager scale;
    private LPV block;
    private StatusBar status;

    public LPVVisualizer(ScaleManager scale, final LPV lpv, LPV block) {
        this.scale = scale;
        this.lpv = lpv;
        this.block = block;
        this.status = null;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (LPVVisualizer.this.status != null) {
                    int w = LPVVisualizer.this.getWidth() / lpv.getWidth();
                    int h = LPVVisualizer.this.getHeight() / lpv.getHeight();
                    int x = e.getX() / w;
                    int y = e.getY() / h;
                    int z = lpv.getDepth() / 2;
                    Vector4f v = lpv.get(x, y, z);
                    LPVVisualizer.this.status.setStatus(String.format("Level %2d. [%2d,%2d,%2d] = (%8.4f,%8.4f,%8.4f,%8.4f)", lpv.getLevel(), x, y, z, Float.valueOf(v.x), Float.valueOf(v.y), Float.valueOf(v.z), Float.valueOf(v.w)));
                }
            }
        });
        scale.addObserver(this);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int w = this.getWidth() / this.lpv.getWidth();
        int h = this.getHeight() / this.lpv.getHeight();
        for (int i = 0; i < this.lpv.getHeight(); ++i) {
            for (int j = 0; j < this.lpv.getWidth(); ++j) {
                g.translate(w * j, h * i);
                Vector4f sh = this.lpv.get(j, this.lpv.getHeight() - i - 1, this.lpv.getDepth() / 2);
                Vector4f b = this.block.get(j, this.lpv.getHeight() - i - 1, this.lpv.getDepth() / 2);
                this.paintSH(sh, b, g, w, h);
                g.translate(-w * j, -h * i);
            }
        }
    }

    private void paintSH(Vector4f sh, Vector4f block, Graphics2D g2d, int w, int h) {
        g2d.setColor(Color.white);
        g2d.drawRect(0, 0, w - 1, h - 1);
        g2d.clipRect(0, 0, w, h);
        if (sh.lengthSquared() != 0.0f || block.lengthSquared() != 0.0f) {
            float r;
            Vector4f dirSH;
            float z;
            float y;
            float x;
            double angle;
            int i;
            int[] polyy;
            int[] polyx;
            if (block.lengthSquared() != 0.0f) {
                g2d.translate((double)w / 2.0, (double)h / 2.0);
                polyx = new int[16];
                polyy = new int[16];
                for (i = 0; i < 16; ++i) {
                    angle = (double)i * 2.0 * Math.PI / 16.0;
                    x = (float)Math.cos(angle);
                    y = (float)Math.sin(angle);
                    z = 0.0f;
                    dirSH = SH.construct(x, y, z);
                    r = Math.max(0.0f, block.dot(dirSH));
                    polyx[i] = (int)(x *= r * this.scale.getScale());
                    polyy[i] = (int)(-(y *= r * this.scale.getScale()));
                }
                g2d.setColor(Color.orange);
                g2d.fillPolygon(polyx, polyy, 16);
                g2d.translate((double)(-w) / 2.0, (double)(-h) / 2.0);
            }
            if (sh.lengthSquared() != 0.0f) {
                g2d.translate((double)w / 2.0, (double)h / 2.0);
                polyx = new int[16];
                polyy = new int[16];
                for (i = 0; i < 16; ++i) {
                    angle = (double)i * 2.0 * Math.PI / 16.0;
                    x = (float)Math.cos(angle);
                    y = (float)Math.sin(angle);
                    z = 0.0f;
                    dirSH = SH.construct(x, y, z);
                    r = Math.max(0.0f, sh.dot(dirSH));
                    polyx[i] = (int)(x *= r * this.scale.getScale());
                    polyy[i] = (int)(-(y *= r * this.scale.getScale()));
                }
                g2d.setColor(Color.white);
                g2d.fillPolygon(polyx, polyy, 16);
                g2d.translate((double)(-w) / 2.0, (double)(-h) / 2.0);
            }
            g2d.translate((double)w / 2.0, (double)h / 2.0);
            g2d.setColor(Color.red);
            g2d.drawLine(-3, 0, 3, 0);
            g2d.drawLine(0, -3, 0, 3);
            g2d.translate((double)(-w) / 2.0, (double)(-h) / 2.0);
        }
        g2d.setClip(null);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }

    public Dimension getSHPanelSize() {
        Dimension d = new Dimension(this.getWidth() / this.lpv.getWidth(), this.getHeight() / this.lpv.getHeight());
        return d;
    }

    public void setStatusBar(StatusBar status) {
        this.status = status;
    }
}

