/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.gui.ControlPanel;
import lpv.gui.LPVSizeDialog;
import lpv.gui.LPVVisualizer;
import lpv.gui.ScaleManager;
import lpv.gui.StatusBar;
import lpv.simulator.Simulator;

public class SimulatorUI
extends JFrame
implements Observer {
    private LPVVisualizer firstVisualizer;
    private LPVVisualizer secondVisualizer;
    private LPVVisualizer accumulationVisualizer;
    private Simulator simulator;
    private ScaleManager scale;
    private ControlPanel controlPanel;
    private StatusBar status;

    public static void main(String[] args) {
        LPVSizeDialog sizeDialog = new LPVSizeDialog();
        sizeDialog.setVisible(true);
        sizeDialog.dispose();
        if (sizeDialog.isSubmitted()) {
            int w = sizeDialog.getSubmittedWidth();
            int h = sizeDialog.getSubmittedHeight();
            int d = sizeDialog.getSubmittedDepth();
            new LPV(w, h, d);
            SimulatorUI simulator = new SimulatorUI(w, h, d);
            simulator.setVisible(true);
        }
    }

    private SimulatorUI(int w, int h, int d) {
        super("LPV Simulator");
        this.setDefaultCloseOperation(3);
        this.simulator = new Simulator(w, h, d);
        this.simulator.addObserver(this);
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(2, 2, 20, 20));
        this.scale = new ScaleManager(1.0f);
        this.firstVisualizer = new LPVVisualizer(this.scale, this.simulator.getFirst(), this.simulator.getGeometry());
        contentPanel.add(this.firstVisualizer);
        this.secondVisualizer = new LPVVisualizer(this.scale, this.simulator.getSecond(), this.simulator.getGeometry());
        contentPanel.add(this.secondVisualizer);
        this.accumulationVisualizer = new LPVVisualizer(this.scale, this.simulator.getAccumulation(), this.simulator.getGeometry());
        contentPanel.add(this.accumulationVisualizer);
        this.controlPanel = new ControlPanel(this, this.simulator, this.scale);
        contentPanel.add(this.controlPanel);
        this.add((Component)contentPanel, "Center");
        this.status = new StatusBar();
        this.add((Component)this.status, "South");
        this.firstVisualizer.setStatusBar(this.status);
        this.secondVisualizer.setStatusBar(this.status);
        this.accumulationVisualizer.setStatusBar(this.status);
        this.pack();
    }

    @Override
    public void update(Observable observable, Object o) {
        Vector4f[] maxs;
        Vector4f max = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        for (Vector4f m : maxs = new Vector4f[]{this.simulator.getFirst().getMax(), this.simulator.getSecond().getMax(), this.simulator.getAccumulation().getMax()}) {
            if (!(m.x * m.x + m.y * m.y > max.x * max.x + max.y * max.y)) continue;
            max.set(m);
        }
        if (max.lengthSquared() > 0.01f) {
            Dimension size = this.accumulationVisualizer.getSHPanelSize();
            this.controlPanel.proposeScale((float)(Math.min(size.getWidth(), size.getHeight()) / (double)max.length()));
        }
        this.firstVisualizer.repaint();
        this.secondVisualizer.repaint();
        this.accumulationVisualizer.repaint();
    }
}

