/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui.card;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lpv.gui.card.InjectorCard;
import lpv.simulation.injector.CenterInjector;
import lpv.simulation.injector.Injector;

public class CenterInjectorCard
extends InjectorCard {
    private JTextField zField;
    private JTextField yField;
    private JTextField xField;
    private JTextField strengthField;
    private JCheckBox normalizeBox;

    public CenterInjectorCard() {
        JPanel contents = new JPanel();
        contents.setLayout(new GridLayout(5, 2, 5, 5));
        contents.add(new JLabel("Strength: "));
        this.strengthField = new JTextField("1.0");
        contents.add(this.strengthField);
        contents.add(new JLabel("Direction's X-component: "));
        this.xField = new JTextField("0.0");
        contents.add(this.xField);
        contents.add(new JLabel("Direction's Y-component: "));
        this.yField = new JTextField("0.0");
        contents.add(this.yField);
        contents.add(new JLabel("Direction's Z-component: "));
        this.zField = new JTextField("0.0");
        contents.add(this.zField);
        contents.add(new JLabel());
        this.normalizeBox = new JCheckBox("Normalize", true);
        contents.add(this.normalizeBox);
        this.add(contents);
    }

    @Override
    public Injector createInjector() {
        try {
            float strength = Float.parseFloat(this.strengthField.getText());
            float x = Float.parseFloat(this.xField.getText());
            float y = Float.parseFloat(this.yField.getText());
            float z = Float.parseFloat(this.zField.getText());
            if (this.normalizeBox.isSelected() && x + y + z != 0.0f) {
                float lengthInv = (float)(1.0 / Math.sqrt(x * x + y * y + z * z));
                x *= lengthInv;
                y *= lengthInv;
                z *= lengthInv;
            }
            return new CenterInjector(strength, x, y, z);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
            return null;
        }
    }
}

