/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui.card;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lpv.gui.card.InjectorCard;
import lpv.simulation.injector.Injector;
import lpv.simulation.injector.WallInjector;

public class LeftWallInjectorCard
extends InjectorCard {
    private JTextField strengthField;
    private JTextField offsetField;

    public LeftWallInjectorCard() {
        JPanel contents = new JPanel();
        contents.setLayout(new GridLayout(5, 2, 5, 5));
        contents.add(new JLabel("Offset from left edge: "));
        this.offsetField = new JTextField("0");
        contents.add(this.offsetField);
        contents.add(new JLabel("Strength: "));
        this.strengthField = new JTextField("1.0");
        contents.add(this.strengthField);
        this.add(contents);
    }

    @Override
    public Injector createInjector() {
        try {
            float strength = Float.parseFloat(this.strengthField.getText());
            int offset = Integer.parseInt(this.offsetField.getText());
            return new WallInjector.Left(offset, strength);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
            return null;
        }
    }
}

