/*
 * Decompiled with CFR 0.152.
 */
package lpv.gui.card;

import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lpv.gui.card.InjectorCard;
import lpv.simulation.injector.Injector;
import lpv.simulation.injector.SinglePixelInjector;

public class SinglePixelInjectorCard
extends InjectorCard {
    private JTextField xField;
    private JTextField yField;
    private JTextField dirXField;
    private JTextField dirYField;
    private JTextField dirZField;
    private JTextField strengthField;
    private JCheckBox normalizeBox;

    public SinglePixelInjectorCard() {
        JPanel contents = new JPanel();
        contents.setLayout(new GridLayout(7, 2, 5, 5));
        contents.add(new JLabel("Position's X-component: "));
        this.xField = new JTextField("0");
        contents.add(this.xField);
        contents.add(new JLabel("Position's Y-component: "));
        this.yField = new JTextField("0");
        contents.add(this.yField);
        contents.add(new JLabel("Strength: "));
        this.strengthField = new JTextField("1.0");
        contents.add(this.strengthField);
        contents.add(new JLabel("Direction's X-component: "));
        this.dirXField = new JTextField("0.0");
        contents.add(this.dirXField);
        contents.add(new JLabel("Direction's Y-component: "));
        this.dirYField = new JTextField("0.0");
        contents.add(this.dirYField);
        contents.add(new JLabel("Direction's Z-component: "));
        this.dirZField = new JTextField("0.0");
        contents.add(this.dirZField);
        contents.add(new JLabel());
        this.normalizeBox = new JCheckBox("Normalize", true);
        contents.add(this.normalizeBox);
        this.add(contents);
    }

    @Override
    public Injector createInjector() {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            float strength = Float.parseFloat(this.strengthField.getText());
            float dx = Float.parseFloat(this.dirXField.getText());
            float dy = Float.parseFloat(this.dirYField.getText());
            float dz = Float.parseFloat(this.dirZField.getText());
            if (this.normalizeBox.isSelected() && dx + dy + dz != 0.0f) {
                float lengthInv = (float)(1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz));
                dx *= lengthInv;
                dy *= lengthInv;
                dz *= lengthInv;
            }
            return new SinglePixelInjector(x, y, dx, dy, dz, strength);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
            return null;
        }
    }
}

