/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation;

import java.util.Collection;
import lpv.simulation.ClearStep;
import lpv.simulation.DownsampleStep;
import lpv.simulation.DumpErrorsStep;
import lpv.simulation.GeometryInjectionStep;
import lpv.simulation.LightInjectionStep;
import lpv.simulation.PropagationStep;
import lpv.simulation.SampleErrorsStep;
import lpv.simulation.Simulation;
import lpv.simulation.injector.Injector;
import lpv.simulation.propagator.PassthroughPropagator;
import lpv.simulation.propagator.Propagator;

public class DefaultSimulation
extends Simulation {
    private LightInjectionStep lightInjectionStep;
    private PassthroughPropagator propagator;
    private GeometryInjectionStep geometryInjectionStep;

    public DefaultSimulation(int iterations) {
        this.addStep(new ClearStep());
        this.geometryInjectionStep = new GeometryInjectionStep();
        this.addStep(this.geometryInjectionStep);
        this.lightInjectionStep = new LightInjectionStep();
        this.addStep(this.lightInjectionStep);
        this.addStep(new DownsampleStep());
        this.addStep(new SampleErrorsStep());
        this.propagator = new PassthroughPropagator();
        for (int i = 0; i < iterations; ++i) {
            this.addStep(new PropagationStep(this.propagator));
            this.addStep(new SampleErrorsStep());
        }
        this.addStep(new DumpErrorsStep());
    }

    public void addLightInjector(Injector injector) {
        this.lightInjectionStep.addInjector(injector);
    }

    public void addLightInjectors(Injector ... injectors) {
        this.lightInjectionStep.addInjectors(injectors);
    }

    public void addLightInjectors(Collection<Injector> injectors) {
        this.lightInjectionStep.addInjectors(injectors);
    }

    public void addGeometryInjector(Injector injector) {
        this.geometryInjectionStep.addInjector(injector);
    }

    public void addGeometryInjectors(Injector ... injectors) {
        this.geometryInjectionStep.addInjectors(injectors);
    }

    public void addGeometryInjectors(Collection<Injector> injectors) {
        this.geometryInjectionStep.addInjectors(injectors);
    }

    public void setPropagator(Propagator propagator) {
        this.propagator.setPropagator(propagator);
    }
}

