/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation;

import java.util.ArrayList;
import java.util.Iterator;
import lpv.simulation.Simulation;
import lpv.simulation.SimulationStep;
import lpv.simulator.Simulator;

public class SimulationThread
extends Thread {
    private Simulation simulation;
    private Simulator simulator;
    private ArrayList<Runnable> handlers;
    private int delay;

    public SimulationThread(Simulator simulator, Simulation simulation, int delay) {
        this.simulator = simulator;
        this.simulation = simulation;
        this.handlers = new ArrayList();
        this.delay = delay;
    }

    public void addCompletionHandler(Runnable handler) {
        this.handlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Iterator<SimulationStep> it = this.simulation.iterator();
            while (it.hasNext()) {
                SimulationStep step = it.next();
                step.run(this.simulator);
                if (!it.hasNext()) continue;
                Thread.sleep(this.delay);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            for (Runnable handler : this.handlers) {
                handler.run();
            }
        }
    }
}

