/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.injector;

import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.SH;
import lpv.simulation.injector.Injector;

public class SinglePixelInjector
implements Injector {
    private int x;
    private int y;
    private float dx;
    private float dy;
    private float dz;
    private float strength;

    public SinglePixelInjector(int x, int y, float dx, float dy, float dz, float strength) {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.strength = strength;
    }

    @Override
    public void inject(LPV lpv) {
        if (this.x >= 0 && this.x < lpv.getWidth(0) && this.y >= 0 && this.y < lpv.getHeight(0)) {
            Vector4f sh = SH.clampedCosineLobe(this.dx, this.dy, this.dz);
            sh.scale(this.strength);
            lpv.get(0, this.x, this.y, lpv.getDepth(0) / 2).add(sh);
        }
    }

    public String toString() {
        return "Pixel - @(" + this.x + ", " + this.y + "):" + this.strength + "x(" + this.dx + ", " + this.dy + ", " + this.dz + ")";
    }
}

