/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.injector;

import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.SH;
import lpv.simulation.injector.Injector;

public class WallInjector {

    public static class Right
    implements Injector {
        private Vector4f sh;
        private float strength;
        private int offset;

        public Right(int offset, float strength) {
            this.offset = offset;
            this.strength = strength;
            this.sh = SH.clampedCosineLobe(-1.0f, 0.0f, 0.0f);
            this.sh.scale(strength);
        }

        @Override
        public void inject(LPV lpv) {
            if (this.offset >= 0 && this.offset < lpv.getWidth(0)) {
                for (int i = 0; i < lpv.getHeight(0); ++i) {
                    for (int j = 0; j < lpv.getDepth(0); ++j) {
                        lpv.get(0, lpv.getWidth(0) - 1 - this.offset, i, j).add(this.sh);
                    }
                }
            }
        }

        public String toString() {
            return "Right wall injector - @" + -this.offset + ":" + this.strength + "x";
        }
    }

    public static class Left
    implements Injector {
        private Vector4f sh;
        private float strength;
        private int offset;

        public Left(int offset, float strength) {
            this.offset = offset;
            this.strength = strength;
            this.sh = SH.clampedCosineLobe(1.0f, 0.0f, 0.0f);
            this.sh.scale(strength);
        }

        @Override
        public void inject(LPV lpv) {
            if (this.offset >= 0 && this.offset < lpv.getWidth(0)) {
                for (int i = 0; i < lpv.getHeight(0); ++i) {
                    for (int j = 0; j < lpv.getDepth(0); ++j) {
                        lpv.get(0, this.offset, i, j).add(this.sh);
                    }
                }
            }
        }

        public String toString() {
            return "Left wall injector - @" + this.offset + ":" + this.strength + "x";
        }
    }
}

