/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.propagator;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.simulation.propagator.Propagator;

public class AndreasKirschPropagator
implements Propagator {
    private static final float Pi = 3.1415925f;
    private static final float SH_c0 = 0.2820948f;
    private static final float SH_c1 = 0.48860252f;
    private static final float SH_cosLobe_c0 = 0.88622695f;
    private static final float SH_cosLobe_c1 = 1.0233268f;
    private static final Matrix3f[] Prop_neighbourOrientations = new Matrix3f[]{new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f), new Matrix3f(-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f), new Matrix3f(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f), new Matrix3f(0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f), new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f), new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f)};
    private static final Vector2f[] Prop_side = new Vector2f[]{new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(-1.0f, 0.0f), new Vector2f(0.0f, -1.0f)};

    @Override
    public void propagate(LPV in, LPV out, LPV acc, LPV geometry, Point3i pos, int iteration) {
        Vector4f contribution = this.Prop_gatherContributions(in, pos);
        if (iteration == 0) {
            contribution.add(in.get(pos.x, pos.y, pos.z));
        }
        out.get(pos.x, pos.y, pos.z).set(contribution);
        acc.get(pos.x, pos.y, pos.z).add(contribution);
    }

    private Vector4f Prop_gatherContributions(LPV in, Point3i cellIndex) {
        Vector4f contribution = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        for (int neighbour = 0; neighbour < 6; ++neighbour) {
            Matrix3f orientation = Prop_neighbourOrientations[neighbour];
            Vector3f mainDirection = new Vector3f(0.0f, 0.0f, 1.0f);
            orientation.transform(mainDirection);
            Point3i neighbourIndex = new Point3i((int)((float)cellIndex.x - mainDirection.x), (int)((float)cellIndex.y - mainDirection.y), (int)((float)cellIndex.z - mainDirection.z));
            Vector4f neighbourCoeffs = neighbourIndex.x >= 0 && neighbourIndex.x < in.getWidth() && neighbourIndex.y >= 0 && neighbourIndex.y < in.getHeight() && neighbourIndex.z >= 0 && neighbourIndex.z < in.getDepth() ? new Vector4f(in.get(neighbourIndex.x, neighbourIndex.y, neighbourIndex.z)) : new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            float directFaceSubtendedSolidAngle = 0.12753713f;
            float sideFaceSubtendedSolidAngle = 0.13478558f;
            float transmittanceValue = 1.0f;
            float reflectionValue = 0.0f;
            float occludedDirectFaceContribution = transmittanceValue * directFaceSubtendedSolidAngle;
            Vector4f mainDirectionCosineLobeSH = AndreasKirschPropagator.SH_evaluateCosineLobe_direct(mainDirection);
            Vector4f mainDirectionSH = AndreasKirschPropagator.SH_evaluate_direct(mainDirection);
            Vector4f tmp = new Vector4f(mainDirectionCosineLobeSH);
            tmp.scale(occludedDirectFaceContribution * neighbourCoeffs.dot(mainDirectionSH));
            contribution.add(tmp);
            for (int sideFace = 0; sideFace < 4; ++sideFace) {
                Vector3f evalDirection = this.Prop_getEvalSideDirection(sideFace, orientation);
                Vector3f reprojDirection = this.Prop_getReprojSideDirection(sideFace, orientation);
                float occludedSideFaceContribution = transmittanceValue * sideFaceSubtendedSolidAngle;
                Vector4f reprojDirectionCosineLobeSH = AndreasKirschPropagator.SH_evaluateCosineLobe_direct(reprojDirection);
                Vector4f evalDirectionSH = AndreasKirschPropagator.SH_evaluate_direct(evalDirection);
                tmp = new Vector4f(reprojDirectionCosineLobeSH);
                tmp.scale(occludedSideFaceContribution * neighbourCoeffs.dot(evalDirectionSH));
                contribution.add(tmp);
            }
        }
        return contribution;
    }

    Vector3f Prop_getEvalSideDirection(int index, Matrix3f orientation) {
        float smallComponent = 0.4472135f;
        float bigComponent = 0.894427f;
        Vector2f side = Prop_side[index];
        Vector3f ret = new Vector3f(side.x * smallComponent, side.y * smallComponent, bigComponent);
        orientation.transform(ret);
        return ret;
    }

    Vector3f Prop_getReprojSideDirection(int index, Matrix3f orientation) {
        Vector2f side = Prop_side[index];
        Vector3f ret = new Vector3f(side.x, side.y, 0.0f);
        orientation.transform(ret);
        return ret;
    }

    private static Vector4f SH_evaluate(Vector3f direction) {
        direction = new Vector3f(direction);
        direction.normalize();
        return new Vector4f(0.2820948f, -0.48860252f * direction.y, 0.48860252f * direction.z, -0.48860252f * direction.x);
    }

    private static Vector4f SH_evaluate_direct(Vector3f direction) {
        return new Vector4f(0.2820948f, -0.48860252f * direction.y, 0.48860252f * direction.z, -0.48860252f * direction.x);
    }

    private static Vector4f SH_evaluate(Vector4f direction) {
        return new Vector4f(0.2820948f * direction.w, -0.48860252f * direction.y, 0.48860252f * direction.z, -0.48860252f * direction.x);
    }

    private static Vector4f SH_evaluateCosineLobe(Vector3f direction) {
        direction = new Vector3f(direction);
        direction.normalize();
        return new Vector4f(0.88622695f, -1.0233268f * direction.y, 1.0233268f * direction.z, -1.0233268f * direction.x);
    }

    private static Vector4f SH_evaluateCosineLobe_direct(Vector3f direction) {
        return new Vector4f(0.88622695f, -1.0233268f * direction.y, 1.0233268f * direction.z, -1.0233268f * direction.x);
    }

    private static Vector4f SH_evaluateCosineLobe_linear(Vector4f direction) {
        return new Vector4f(0.88622695f * direction.w, -1.0233268f * direction.y, 1.0233268f * direction.z, -1.0233268f * direction.x);
    }
}

