/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.propagator;

import javax.vecmath.Point3i;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.simulation.propagator.Propagator;

public class ExperimentalPropagator
implements Propagator {
    private float factor;

    public ExperimentalPropagator(float factor) {
        this.factor = factor;
    }

    @Override
    public void propagate(LPV in, LPV out, LPV acc, LPV geometry, Point3i pos, int iteration) {
        Vector4f pixelCoeffs = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    this.IVPropagateDir(pixelCoeffs, in, pos, new Point3i(i, j, k));
                }
            }
        }
        pixelCoeffs.scale(this.factor);
        if (iteration == 0) {
            acc.get(pos.x, pos.y, pos.z).add(in.get(pos.x, pos.y, pos.z));
        }
        out.get(pos.x, pos.y, pos.z).set(pixelCoeffs);
        acc.get(pos.x, pos.y, pos.z).add(pixelCoeffs);
    }

    void IVPropagateDir(Vector4f pixelCoeffs, LPV in, Point3i pos, Point3i nOffset) {
        Point3i p = new Point3i(pos.x + nOffset.x, pos.y + nOffset.y, pos.z + nOffset.z);
        Vector4f sampleCoeffs = in.get(p.x, p.y, p.z);
        if (sampleCoeffs.x != 0.0f || sampleCoeffs.y != 0.0f || sampleCoeffs.z != 0.0f || sampleCoeffs.w != 0.0f) {
            Vector3f normalizedOffset = new Vector3f(nOffset.x, nOffset.y, nOffset.z);
            normalizedOffset.normalize();
            Vector4f shIncomingDirFunction = this.Cone90Degree(normalizedOffset);
            float incidentLuminance = Math.max(0.0f, sampleCoeffs.dot(shIncomingDirFunction));
            Vector4f shOutgoing = this.Cone90Degree(this.getPrimaryDirection(sampleCoeffs));
            shOutgoing.scale(incidentLuminance);
            pixelCoeffs.add(shOutgoing);
        }
    }

    private Vector4f Cone90Degree(Vector3f vcDir) {
        return this.SHProjectCone(vcDir, (float)Math.toRadians(90.0));
    }

    private Vector4f Cone45Degree(Vector3f vcDir) {
        return this.SHProjectCone(vcDir, (float)Math.toRadians(45.0));
    }

    private Vector4f Cone180Degree(Vector3f vcDir) {
        return this.SHProjectCone(vcDir, (float)Math.toRadians(180.0));
    }

    private Vector3f getPrimaryDirection(Vector4f sh) {
        Vector3f dir = new Vector3f(sh.w, sh.y, -sh.z);
        if (dir.x == 0.0f && dir.y == 0.0f && dir.z == 0.0f) {
            return dir;
        }
        dir.normalize();
        return dir;
    }

    private Vector4f SHProjectCone(Vector3f vcDir, float angle) {
        Vector2f vZHCoeffs = new Vector2f(0.5f * (1.0f - (float)Math.cos(angle)), 0.75f * (float)Math.sin(angle) * (float)Math.sin(angle));
        return this.SHRotate(vcDir, vZHCoeffs);
    }

    private Vector4f SHRotate(Vector3f vcDir, Vector2f vZHCoeffs) {
        Vector2f theta12_cs;
        if (vcDir.x == 0.0f && vcDir.y == 0.0f) {
            theta12_cs = new Vector2f(0.0f, 0.0f);
        } else {
            theta12_cs = new Vector2f(vcDir.x, vcDir.y);
            theta12_cs.normalize();
        }
        Vector2f phi12_cs = new Vector2f();
        phi12_cs.x = (float)Math.sqrt(1.0f - vcDir.z * vcDir.z);
        phi12_cs.y = vcDir.z;
        Vector4f vResult = new Vector4f();
        vResult.x = vZHCoeffs.x;
        vResult.y = vZHCoeffs.y * phi12_cs.x * theta12_cs.y;
        vResult.z = -vZHCoeffs.y * phi12_cs.y;
        vResult.w = vZHCoeffs.y * phi12_cs.x * theta12_cs.x;
        return vResult;
    }
}

