/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.propagator;

import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.SH;
import lpv.simulation.propagator.Propagator;

public class NvidiaPropagator
implements Propagator {
    private float factor;
    private PropagateConsts[] g_propagateValues;
    private boolean copyInjected;
    private static final Point3i[] offsets = new Point3i[]{new Point3i(0, 0, 1), new Point3i(1, 0, 0), new Point3i(0, 0, -1), new Point3i(-1, 0, 0), new Point3i(0, 1, 0), new Point3i(0, -1, 0)};
    private static final Vector4f[] faceCoeffs = new Vector4f[]{SH.clampedCosineLobe(offsets[0]), SH.clampedCosineLobe(offsets[1]), SH.clampedCosineLobe(offsets[2]), SH.clampedCosineLobe(offsets[3]), SH.clampedCosineLobe(offsets[4]), SH.clampedCosineLobe(offsets[5])};

    public NvidiaPropagator(float factor, boolean copyInjected) {
        this.factor = factor;
        this.copyInjected = copyInjected;
        this.g_propagateValues = new PropagateConsts[36];
        for (int i = 0; i < this.g_propagateValues.length; ++i) {
            this.g_propagateValues[i] = new PropagateConsts();
        }
        for (int neighbor = 0; neighbor < 6; ++neighbor) {
            Vector3f neighborCellCenter = new Vector3f(NvidiaPropagator.offsets[neighbor].x, NvidiaPropagator.offsets[neighbor].y, NvidiaPropagator.offsets[neighbor].z);
            for (int face = 0; face < 6; ++face) {
                Vector3f facePosition = new Vector3f(NvidiaPropagator.offsets[face].x, NvidiaPropagator.offsets[face].y, NvidiaPropagator.offsets[face].z);
                facePosition.scale(0.5f);
                Vector3f vecFromNCC = new Vector3f(facePosition);
                vecFromNCC.sub(neighborCellCenter);
                float length = vecFromNCC.length();
                vecFromNCC.scale(1.0f / length);
                this.g_propagateValues[neighbor * 6 + face].neighborOffset = new Vector4f(neighborCellCenter.x, neighborCellCenter.y, neighborCellCenter.z, 1.0f);
                this.g_propagateValues[neighbor * 6 + face].x = vecFromNCC.x;
                this.g_propagateValues[neighbor * 6 + face].y = vecFromNCC.y;
                this.g_propagateValues[neighbor * 6 + face].z = vecFromNCC.z;
                this.g_propagateValues[neighbor * 6 + face].solidAngle = length <= 0.5f ? 0.0f : (length >= 1.5f ? 0.03188428f : 0.033695597f);
            }
        }
    }

    @Override
    public void propagate(LPV in, LPV out, LPV acc, LPV geometry, Point3i pos, int iteration) {
        Vector4f[] GV = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};
        this.loadOffsetTexValue(geometry, pos, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), GV[0]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(0.0f, 0.0f, -1.0f, 1.0f), GV[1]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(0.0f, -1.0f, 0.0f, 1.0f), GV[2]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(-1.0f, 0.0f, 0.0f, 1.0f), GV[3]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(-1.0f, -1.0f, 0.0f, 1.0f), GV[4]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(-1.0f, 0.0f, -1.0f, 1.0f), GV[5]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(0.0f, -1.0f, -1.0f, 1.0f), GV[6]);
        this.loadOffsetTexValue(geometry, pos, new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f), GV[7]);
        Vector4f SHCoefficients = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        int index = 0;
        for (int neighbor = 0; neighbor < 6; ++neighbor) {
            Vector4f inSHCoefficients = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vector4f neighborOffset = this.g_propagateValues[neighbor * 6].neighborOffset;
            this.loadOffsetTexValue(in, pos, neighborOffset, inSHCoefficients);
            Vector4f GVSHCoefficients = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
            if (neighbor == 1) {
                GVSHCoefficients.add(GV[6]);
                GVSHCoefficients.add(GV[1]);
                GVSHCoefficients.add(GV[2]);
                GVSHCoefficients.add(GV[0]);
            } else if (neighbor == 3) {
                GVSHCoefficients.add(GV[7]);
                GVSHCoefficients.add(GV[5]);
                GVSHCoefficients.add(GV[4]);
                GVSHCoefficients.add(GV[3]);
            } else if (neighbor == 4) {
                GVSHCoefficients.add(GV[0]);
                GVSHCoefficients.add(GV[3]);
                GVSHCoefficients.add(GV[1]);
                GVSHCoefficients.add(GV[5]);
            } else if (neighbor == 5) {
                GVSHCoefficients.add(GV[2]);
                GVSHCoefficients.add(GV[4]);
                GVSHCoefficients.add(GV[6]);
                GVSHCoefficients.add(GV[7]);
            } else if (neighbor == 0) {
                GVSHCoefficients.add(GV[0]);
                GVSHCoefficients.add(GV[3]);
                GVSHCoefficients.add(GV[2]);
                GVSHCoefficients.add(GV[4]);
            } else if (neighbor == 2) {
                GVSHCoefficients.add(GV[1]);
                GVSHCoefficients.add(GV[5]);
                GVSHCoefficients.add(GV[6]);
                GVSHCoefficients.add(GV[7]);
            }
            GVSHCoefficients.scale(0.25f);
            for (int face = 0; face < 6; ++face) {
                Vector3f dir = new Vector3f();
                dir.x = this.g_propagateValues[index].x;
                dir.y = this.g_propagateValues[index].y;
                dir.z = this.g_propagateValues[index].z;
                dir.normalize();
                float solidAngle = this.g_propagateValues[index].solidAngle;
                Vector4f dirSH = SH.construct(dir.x, dir.y, dir.z);
                float occlusion = 1.0f - Math.max(0.0f, Math.min(1.0f, GVSHCoefficients.dot(dirSH)));
                float inFlux = 0.0f;
                float flux = occlusion * solidAngle * Math.max(0.0f, inSHCoefficients.x * dirSH.x + inSHCoefficients.y * dirSH.y + inSHCoefficients.z * dirSH.z + inSHCoefficients.w * dirSH.w);
                inFlux += flux;
                Vector4f coeffs = faceCoeffs[face];
                SHCoefficients.add(new Vector4f((inFlux *= this.factor) * coeffs.x, inFlux * coeffs.y, inFlux * coeffs.z, inFlux * coeffs.w));
                ++index;
            }
        }
        if (this.copyInjected && iteration == 0) {
            SHCoefficients.add(in.get(pos.x, pos.y, pos.z));
        }
        out.get(pos.x, pos.y, pos.z).set(SHCoefficients);
        acc.get(pos.x, pos.y, pos.z).add(SHCoefficients);
    }

    private void loadOffsetTexValue(LPV in, Point3i pos, Vector4f neighborOffset, Vector4f inSHCoefficients) {
        int x = (int)((float)pos.x + neighborOffset.x);
        int y = (int)((float)pos.y + neighborOffset.y);
        int z = (int)((float)pos.z + neighborOffset.z);
        inSHCoefficients.set(in.get(x, y, z));
    }

    private static class PropagateConsts {
        Vector4f neighborOffset;
        float solidAngle;
        float x;
        float y;
        float z;

        private PropagateConsts() {
        }
    }
}

