/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulation.propagator;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector4f;
import lpv.LPV;
import lpv.simulation.propagator.Propagator;

public class SSLPVPropagator
implements Propagator {
    private static final Matrix4f px = new Matrix4f(0.16666667f, 0.0f, 0.0f, -0.036816794f, 0.0f, 0.06982864f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f, 0.0f, -0.23994379f, 0.0f, 0.0f, 0.061658796f);
    private static final Matrix4f mx = new Matrix4f(0.16666667f, 0.0f, 0.0f, 0.036816794f, 0.0f, 0.06982864f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f, 0.0f, 0.23994379f, 0.0f, 0.0f, 0.061658796f);
    private static final Matrix4f py = new Matrix4f(0.16666667f, -0.036816794f, 0.0f, 0.0f, -0.23994379f, 0.061658796f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f);
    private static final Matrix4f my = new Matrix4f(0.16666667f, 0.036816794f, 0.0f, 0.0f, 0.23994379f, 0.061658796f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f);
    private static final Matrix4f pz = new Matrix4f(0.16666667f, 0.0f, -0.036816794f, 0.0f, 0.0f, 0.06982864f, 0.0f, 0.0f, -0.23994379f, 0.0f, 0.061658796f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f);
    private static final Matrix4f mz = new Matrix4f(0.16666667f, 0.0f, 0.036816794f, 0.0f, 0.0f, 0.06982864f, 0.0f, 0.0f, 0.23994379f, 0.0f, 0.061658796f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06982864f);
    private float factor;

    public SSLPVPropagator(float factor) {
        this.factor = factor;
    }

    @Override
    public void propagate(LPV in, LPV out, LPV acc, LPV geometry, Point3i pos, int iteration) {
        Point3i kUp = new Point3i(pos.x, pos.y + 1, pos.z);
        Point3i kDown = new Point3i(pos.x, pos.y - 1, pos.z);
        Point3i kFront = new Point3i(pos.x, pos.y, pos.z + 1);
        Point3i kBack = new Point3i(pos.x, pos.y, pos.z - 1);
        Point3i kRight = new Point3i(pos.x + 1, pos.y, pos.z);
        Point3i kLeft = new Point3i(pos.x - 1, pos.y, pos.z);
        Vector4f kUpSH = this.texture(in, kUp);
        Vector4f kDownSH = this.texture(in, kDown);
        Vector4f kRightSH = this.texture(in, kRight);
        Vector4f kLeftSH = this.texture(in, kLeft);
        Vector4f kFrontSH = this.texture(in, kFront);
        Vector4f kBackSH = this.texture(in, kBack);
        Vector4f kRes = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        px.transform(kRightSH);
        kRes.add(kRightSH);
        mx.transform(kLeftSH);
        kRes.add(kLeftSH);
        py.transform(kUpSH);
        kRes.add(kUpSH);
        my.transform(kDownSH);
        kRes.add(kDownSH);
        pz.transform(kFrontSH);
        kRes.add(kFrontSH);
        mz.transform(kBackSH);
        kRes.add(kBackSH);
        kRes.scale(this.factor);
        out.get(pos.x, pos.y, pos.z).set(kRes);
        acc.get(pos.x, pos.y, pos.z).add(kRes);
    }

    private Vector4f texture(LPV in, Point3i p) {
        if (p.x >= 0 && p.x < in.getWidth() && p.y >= 0 && p.y < in.getHeight() && p.z >= 0 && p.z < in.getDepth()) {
            return new Vector4f(in.get(p.x, p.y, p.z));
        }
        return new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

