/*
 * Decompiled with CFR 0.152.
 */
package lpv.simulator;

import java.util.Observable;
import javax.vecmath.Point3i;
import lpv.ErrorStore;
import lpv.LPV;
import lpv.simulation.injector.Injector;
import lpv.simulation.propagator.Propagator;

public class Simulator
extends Observable {
    private LPV first;
    private LPV second;
    private LPV accumulation;
    private int w;
    private int h;
    private int d;
    private int iteration;
    private LPV geometry;
    private ErrorStore errors;

    public Simulator(int w, int h, int d) {
        this.first = new LPV(w, h, d);
        this.second = new LPV(w, h, d);
        this.accumulation = new LPV(w, h, d);
        this.geometry = new LPV(w, h, d);
        this.errors = new ErrorStore();
        this.w = w;
        this.h = h;
        this.d = d;
        this.iteration = 0;
        this.errors.registerSource("accumulation");
    }

    public void injectLight(Injector injector) {
        injector.inject(this.first);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void injectGeometry(Injector injector) {
        injector.inject(this.geometry);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void flip() {
        LPV tmp = this.first;
        this.first = this.second;
        this.second = tmp;
        ++this.iteration;
    }

    public void propagate(Propagator propagator) {
        int oldLevel = this.accumulation.getLevel();
        int levels = this.accumulation.getLevels();
        for (int level = 0; level < levels; ++level) {
            this.first.setLevel(level);
            this.second.setLevel(level);
            this.accumulation.setLevel(level);
            this.geometry.setLevel(level);
            for (int x = 0; x < this.w >> level; ++x) {
                for (int y = 0; y < this.h >> level; ++y) {
                    for (int z = 0; z < this.d >> level; ++z) {
                        propagator.propagate(this.first, this.second, this.accumulation, this.geometry, new Point3i(x, y, z), this.iteration);
                    }
                }
            }
        }
        this.first.setLevel(oldLevel);
        this.second.setLevel(oldLevel);
        this.accumulation.setLevel(oldLevel);
        this.geometry.setLevel(oldLevel);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void setLevel(int level) {
        this.first.setLevel(level);
        this.second.setLevel(level);
        this.accumulation.setLevel(level);
        this.geometry.setLevel(level);
        this.setChanged();
        this.notifyObservers(this);
    }

    public void clear() {
        this.first.clear();
        this.second.clear();
        this.accumulation.clear();
        this.geometry.clear();
        this.errors.clear();
        this.setChanged();
        this.notifyObservers(this);
        this.iteration = 0;
    }

    public LPV getFirst() {
        return this.first;
    }

    public LPV getSecond() {
        return this.second;
    }

    public LPV getAccumulation() {
        return this.accumulation;
    }

    public LPV getGeometry() {
        return this.geometry;
    }

    public void downsample() {
        this.first.downsample();
        this.second.downsample();
        this.accumulation.downsample();
        this.geometry.downsample();
        this.setChanged();
        this.notifyObservers(this);
    }

    public void sampleErrors() {
        this.errors.add("accumulation", this.accumulation.getError());
    }

    public void dumpErrors() {
        this.errors.dump();
    }

    public ErrorStore getErrors() {
        return this.errors;
    }
}

