package lpv;

import javax.vecmath.Vector4f;

public class Volume {
	private Vector4f[][][] lpv;
	private int w;
	private int h;
	private int d;
	
	public Volume(int w, int h, int d) {
		this.lpv = new Vector4f[d][h][w];
		for(int i = 0; i < d; i++) {
			for(int j = 0; j < h; j++) {
				for(int k = 0; k < w; k++) {
					lpv[i][j][k] = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
				}
			}
		}
		
		this.w = w;
		this.h = h;
		this.d = d;
	}
	
	public Vector4f get(int x, int y, int z) {
		x = clamp(x, 0, w-1);
		y = clamp(y, 0, h-1);
		z = clamp(z, 0, d-1);
		return lpv[z][y][x];
	}
	
	private int clamp(int value, int min, int max) {
		if(value < min) return min;
		else if(value > max) return max;
		else return value;
	}

	public void clear() {
		for(int i = 0; i < d; i++) {
			for(int j = 0; j < h; j++) {
				for(int k = 0; k < w; k++) {
					lpv[i][j][k].set(0.0f, 0.0f, 0.0f, 0.0f);
				}
			}
		}
	}

	public int getWidth() {
		return w;
	}

	public int getHeight() {
		return h;
	}

	public int getDepth() {
		return d;
	}
	
	public Vector4f getMax() {
		Vector4f max = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
		float maxLenSq = 0.0f;
		for(int i = 0; i < d; i++) {
			for(int j = 0; j < h; j++) {
				for(int k = 0; k < w; k++) {
					float tmpLenSq = lpv[i][j][k].x * lpv[i][j][k].x + lpv[i][j][k].y * lpv[i][j][k].y;
					if(tmpLenSq > maxLenSq) {
						maxLenSq = tmpLenSq;
						max.set(lpv[i][j][k]);
					}
				}
			}
		}
		return max;
	}
}
