package lpv.gui;

import java.awt.Color;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FloatValidator implements DocumentListener {
	private JTextField field;
	private Color bg;

	public FloatValidator(JTextField field) {
		this.field = field;
		this.bg = field.getBackground();
	}
	
	private void validate() {
		try {
			String text = field.getText();
			Float.parseFloat(text);
			field.setBackground(bg);
		} catch(NumberFormatException e) {
			field.setBackground(Color.red);
		}
	}
	
	@Override
	public void changedUpdate(DocumentEvent de) {
		validate();
	}

	@Override
	public void insertUpdate(DocumentEvent de) {
		validate();
	}

	@Override
	public void removeUpdate(DocumentEvent de) {
		validate();
	}

}
