package lpv.gui;

public enum PropagatorType {
	nvidia_copy		(true, 	"nVidia Propagator (copy)",		"http://developer.nvidia.com/nvidia-graphics-sdk-11-direct3d"),
	nvidia_nocopy	(true, 	"nVidia Propagator (no-copy)",	"http://developer.nvidia.com/nvidia-graphics-sdk-11-direct3d"),
	experimental	(true, 	"Experimental propagator",		""), 
	crytek_siggraph	(true, 	"CryTek SIGGRAPH 2009", 		"http://www.crytek.com/cryengine/cryengine3/presentations/light-propagation-volumes-in-cryengine-3"),
	andreas_kirsch	(false, "Andreas Kirsch's LPV lab", 	"http://blog.blackhc.net/2010/07/light-propagation-volumes/"),
	lee_salzman		(true,	"Lee Salzman's LPV demo",		"http://lee.fov120.com/"), 
	benjamin_thaut	(true, 	"Benjamin Thaut's LPV demo",	"http://3d.benjamin-thaut.de/?p=16"),
	rafal_wrobel	(false,	"Rafal Wrobel's LPV demo",		"http://www.rafwrobel.com/lpv/lpv.html"),
	sslpv			(true, 	"SSLPV propagator",				"http://cg.alexandra.dk/publications/sslpv/");
	
	private String name;
	private String url;
	private boolean supportsFactor;

	private PropagatorType(boolean supportsFactor, String name, String url) {
		this.name = name;
		this.url = url;
		this.supportsFactor = supportsFactor;
	}

	@Override
	public String toString() {
		return name;
	}

	public String getName() {
		return name;
	}

	public String getUrl() {
		return url;
	}
	
	public boolean supportsFactor() {
		return supportsFactor;
	}
}
