package lpv.gui.card;

import java.awt.GridLayout;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lpv.simulation.injector.CenterInjector;
import lpv.simulation.injector.Injector;

public class CenterInjectorCard extends InjectorCard {

	private JTextField zField;
	private JTextField yField;
	private JTextField xField;
	private JTextField strengthField;
	private JCheckBox normalizeBox;

	public CenterInjectorCard() {
		JPanel contents = new JPanel();
		contents.setLayout(new GridLayout(5, 2, 5, 5));
		
		contents.add(new JLabel("Strength: "));
		contents.add(strengthField = new JTextField("1.0"));
		
		contents.add(new JLabel("Direction's X-component: "));
		contents.add(xField = new JTextField("0.0"));
		
		contents.add(new JLabel("Direction's Y-component: "));
		contents.add(yField = new JTextField("0.0"));
		
		contents.add(new JLabel("Direction's Z-component: "));
		contents.add(zField = new JTextField("0.0"));
		
		contents.add(new JLabel());
		contents.add(normalizeBox = new JCheckBox("Normalize", true));
		
		add(contents);
	}
	
	@Override
	public Injector createInjector() {
		try {
			float strength = Float.parseFloat(strengthField.getText());
			float x = Float.parseFloat(xField.getText());
			float y = Float.parseFloat(yField.getText());
			float z = Float.parseFloat(zField.getText());
			
			if(normalizeBox.isSelected() && x+y+z != 0.0f) {
				float lengthInv = (float)(1.0 / Math.sqrt(x*x + y*y + z*z));
				x *= lengthInv;
				y *= lengthInv;
				z *= lengthInv;
			}
			return new CenterInjector(strength, x, y, z);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
			return null;
		}
		
	}

}
