package lpv.gui.card;

import java.awt.GridLayout;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lpv.simulation.injector.CenterInjector;
import lpv.simulation.injector.Injector;
import lpv.simulation.injector.WallInjector;

public class LeftWallInjectorCard extends InjectorCard {

	private JTextField strengthField;
	private JTextField offsetField;

	public LeftWallInjectorCard() {
		JPanel contents = new JPanel();
		contents.setLayout(new GridLayout(5, 2, 5, 5));
		
		contents.add(new JLabel("Offset from left edge: "));
		contents.add(offsetField = new JTextField("0"));
		
		contents.add(new JLabel("Strength: "));
		contents.add(strengthField = new JTextField("1.0"));
		
		
		add(contents);
	}
	
	@Override
	public Injector createInjector() {
		try {
			float strength = Float.parseFloat(strengthField.getText());
			int offset = Integer.parseInt(offsetField.getText());
			return new WallInjector.Left(offset, strength);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
			return null;
		}
	}
}
