package lpv.gui.card;

import java.awt.GridLayout;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lpv.simulation.injector.Injector;
import lpv.simulation.injector.WallInjector;

public class RightWallInjectorCard extends InjectorCard {
	private JTextField strengthField;
	private JTextField offsetField;

	public RightWallInjectorCard() {
		JPanel contents = new JPanel();
		contents.setLayout(new GridLayout(5, 2, 5, 5));
		
		contents.add(new JLabel("Offset from right edge: "));
		contents.add(offsetField = new JTextField("0"));
		
		contents.add(new JLabel("Strength: "));
		contents.add(strengthField = new JTextField("1.0"));
		
		
		add(contents);
	}
	
	@Override
	public Injector createInjector() {
		try {
			float strength = Float.parseFloat(strengthField.getText());
			int offset = Integer.parseInt(offsetField.getText());
			return new WallInjector.Right(offset, strength);
		} catch(NumberFormatException e) {
			JOptionPane.showMessageDialog(this, "Invalid input. " + e.getMessage());
			return null;
		}
	}
}
