package lpv.simulation;

import java.util.Collection;

import lpv.simulation.injector.Injector;
import lpv.simulation.propagator.PassthroughPropagator;
import lpv.simulation.propagator.Propagator;

public class DefaultSimulation extends Simulation {
	
	private LightInjectionStep lightInjectionStep;
	private PassthroughPropagator propagator;
	private GeometryInjectionStep geometryInjectionStep;

	public DefaultSimulation(int iterations) {
		addStep(new ClearStep());
		addStep(geometryInjectionStep = new GeometryInjectionStep());
		addStep(lightInjectionStep = new LightInjectionStep());
		addStep(new DownsampleStep());
		addStep(new SampleErrorsStep());
		propagator = new PassthroughPropagator();
		for(int i = 0; i < iterations; i++) {
			addStep(new PropagationStep(propagator));
			addStep(new SampleErrorsStep());
		}
		addStep(new DumpErrorsStep());
	}
	
	public void addLightInjector(Injector injector) {
		lightInjectionStep.addInjector(injector);
	}
	
	public void addLightInjectors(Injector... injectors) {
		lightInjectionStep.addInjectors(injectors);
	}

	public void addLightInjectors(Collection<Injector> injectors) {
		lightInjectionStep.addInjectors(injectors);
	}
	
	public void addGeometryInjector(Injector injector) {
		geometryInjectionStep.addInjector(injector);
	}
	
	public void addGeometryInjectors(Injector... injectors) {
		geometryInjectionStep.addInjectors(injectors);
	}

	public void addGeometryInjectors(Collection<Injector> injectors) {
		geometryInjectionStep.addInjectors(injectors);
	}
	
	public void setPropagator(Propagator propagator) {
		this.propagator.setPropagator(propagator);
	}
	
}
