package lpv.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import lpv.simulation.injector.Injector;
import lpv.simulator.Simulator;

public class GeometryInjectionStep implements SimulationStep {
	private ArrayList<Injector> injectors;
	
	public GeometryInjectionStep(Injector... injectors) {
		this.injectors = new ArrayList<Injector>(Arrays.asList(injectors));
	}
	
	public GeometryInjectionStep() {
		this.injectors = new ArrayList<Injector>();
	}
	
	public GeometryInjectionStep(Collection<Injector> injectors) {
		this.injectors = new ArrayList<Injector>(injectors);
	}

	public void addInjector(Injector injector) {
		injectors.add(injector);
	}
	
	@Override
	public void run(Simulator simulator) {
		for(Injector injector : injectors) {
			simulator.injectGeometry(injector);
		}
	}

	public void addInjectors(Injector... injectors) {
		this.injectors.addAll(Arrays.asList(injectors));
	}

	public void addInjectors(Collection<Injector> injectors) {
		this.injectors.addAll(injectors);
	}
}
