package lpv.simulation;

import lpv.simulation.propagator.Propagator;
import lpv.simulator.Simulator;

public class PropagationStep implements SimulationStep {
	private Propagator propagator;

	public PropagationStep(Propagator propagator) {
		this.propagator = propagator;
	}
	
	public PropagationStep() {
		this.propagator = null;
	}
	
	public void setPropagator(Propagator propagator) {
		this.propagator = propagator;
	}
	
	@Override
	public void run(Simulator simulator) {
		simulator.propagate(propagator);
		simulator.flip();
	}
}
