package lpv.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class Simulation implements Iterable<SimulationStep> {
	private ArrayList<SimulationStep> steps;
	
	public Simulation() {
		this.steps = new ArrayList<SimulationStep>();
	}
	
	public Simulation(SimulationStep... steps) {
		this.steps = new ArrayList<SimulationStep>(Arrays.asList(steps));
	}
	
	public Simulation(Collection<? extends SimulationStep> steps) {
		this.steps = new ArrayList<SimulationStep>(steps);
	}
	
	public void addStep(SimulationStep step) {
		steps.add(step);
	}
	
	@Override
	public Iterator<SimulationStep> iterator() {
		return new ArrayList<SimulationStep>(steps).iterator();
	}
	
}
