package lpv.simulation.injector;

import javax.vecmath.Vector4f;

import lpv.LPV;
import lpv.SH;

public class CenterInjector implements Injector {
	
	private float strength;
	private float x;
	private float y;
	private float z;

	public CenterInjector(float strength, float x, float y, float z) {
		this.strength = strength;
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	@Override
	public void inject(LPV lpv) {
		Vector4f sh;
		sh = SH.clampedCosineLobe(x, y, z);
		sh.scale(strength);
		int w = lpv.getWidth(0) / 2;
		int h = lpv.getHeight(0) / 2;
		int d = lpv.getDepth(0) / 2;
		for(int i = -1; i <= 1; i++) {
			for(int j = -1; j <= 1; j++) {
				for(int k = -1; k <= 1; k++) {
					if(w + i >= 0 && w + i < lpv.getWidth(0) && 
							h + j >= 0 && h + j < lpv.getHeight(0) &&
							d + k >= 0 && d + k < lpv.getDepth(0)) {
						lpv.get(0, w + i, h + j, d + k).add(sh);
					}
				}
			}
		}
	}

	@Override
	public String toString() {
		return "Centered blob - " + strength + "x(" + x + ", " + y + ", " + z + ")";
	}

}
