package lpv.simulation.injector;

import javax.vecmath.Vector4f;

import lpv.LPV;
import lpv.SH;

public class SinglePixelInjector implements Injector {
	private int x;
	private int y;
	private float dx;
	private float dy;
	private float dz;
	private float strength;

	public SinglePixelInjector(int x, int y, float dx, float dy, float dz, float strength) {
		this.x = x;
		this.y = y;
		this.dx = dx;
		this.dy = dy;
		this.dz = dz;
		this.strength = strength;
	}
	
	@Override
	public void inject(LPV lpv) {
		if(x >= 0 && x < lpv.getWidth(0) && 
				y >= 0 && y < lpv.getHeight(0)) {
			Vector4f sh = SH.clampedCosineLobe(dx, dy, dz);
			sh.scale(strength);
			lpv.get(0, x, y, lpv.getDepth(0)/2).add(sh);
		}
	}
	
	@Override
	public String toString() {
		return "Pixel - @(" + x + ", " + y + "):" + strength + "x(" + dx + ", " + dy + ", " + dz + ")";
	}
}
