package lpv.simulation.injector;

import javax.vecmath.Vector4f;

import lpv.LPV;
import lpv.SH;

public class WallInjector {

	public static class Left implements Injector {
		private Vector4f sh;
		private float strength;
		private int offset;
		
		public Left(int offset, float strength) {
			this.offset = offset;
			this.strength = strength;
			sh = SH.clampedCosineLobe(1.0f, 0.0f, 0.0f);
			sh.scale(strength);
		}
		
		@Override
		public void inject(LPV lpv) {
			if(offset >= 0 && offset < lpv.getWidth(0)) {
				for(int i = 0; i < lpv.getHeight(0); i++) {
					for(int j = 0; j < lpv.getDepth(0); j++) {
						lpv.get(0, offset, i, j).add(sh);
					}
				}
			}
		}

		@Override
		public String toString() {
			return "Left wall injector - @" + offset + ":" + strength + "x";
		}
	}
	
	public static class Right implements Injector {
		private Vector4f sh;
		private float strength;
		private int offset;
		
		public Right(int offset, float strength) {
			this.offset = offset;
			this.strength = strength;
			sh = SH.clampedCosineLobe(-1.0f, 0.0f, 0.0f);
			sh.scale(strength);
		}
		
		@Override
		public void inject(LPV lpv) {
			if(offset >= 0 && offset < lpv.getWidth(0)) {
				for(int i = 0; i < lpv.getHeight(0); i++) {
					for(int j = 0; j < lpv.getDepth(0); j++) {
						lpv.get(0, lpv.getWidth(0)-1-offset, i, j).add(sh);
					}
				}
			}
		}

		@Override
		public String toString() {
			return "Right wall injector - @" + -offset + ":" + strength + "x";
		}
	}
	
}
