#version 420

in vec2 texture_Coord;
in vec4 view_Vertex;
in vec3 view_Normal;
in vec3 model_Normal;

uniform float camera_FarPlane;
uniform vec4 light_Colors[3];
uniform sampler2D texture_Diffuse;
uniform int light_Id;

out vec4 encodedDepth;
out vec4 reflectedColor;
out vec4 encodedNormal;

vec4 encodeDepth(float depth)
{
	float d0 = depth;
	float d1 = depth * 256.0;
	float d2 = depth * 256.0 * 256.0;
	float d3 = depth * 256.0 * 256.0 * 256.0;

	vec4 result;

	result.a = mod(d3, 1.0);
	result.r = mod((d2 - result.a / 256.0), 1.0);
	result.g = mod((d1 - result.r / 256.0), 1.0);
	result.b = d0 - result.g / 256.0;
	return result;
}

void main() {
	vec3 vertex = vec3(view_Vertex / view_Vertex.w);
	float depth = length(vertex);
	encodedDepth = encodeDepth(depth/camera_FarPlane);
	vec3 N = normalize(view_Normal);
	vec3 L = normalize(-view_Vertex.xyz);
	encodedNormal = vec4(normalize(model_Normal) * 0.5 + 0.5, 1.0);
	
	reflectedColor = vec4(light_Colors[light_Id].rgb * max(dot(N,L), 0.0) * texture(texture_Diffuse, texture_Coord).rgb, 1.0);
}

