#version 420

in vec4 osg_Vertex;
in vec3 osg_Normal;
in vec2 osg_MultiTexCoord0;

uniform mat4 osg_ModelViewProjectionMatrix;
uniform mat4 osg_ModelViewMatrix;
uniform mat3 osg_NormalMatrix;

out vec2 texture_Coord;
out vec3 model_Normal;
out vec3 view_Normal;
out vec4 view_Vertex;

void main() {
	view_Normal = normalize(osg_NormalMatrix * osg_Normal);
	view_Vertex = osg_ModelViewMatrix * osg_Vertex;
	model_Normal = normalize(osg_Normal);
	texture_Coord = osg_MultiTexCoord0;
	
	gl_Position = osg_ModelViewProjectionMatrix * osg_Vertex;
}
