#version 420

in vec4 osg_Vertex;
in vec3 osg_Normal;
in vec3 osg_Tangent;
in vec3 osg_Binormal;
in vec2 osg_MultiTexCoord0;

uniform mat4 osg_ModelViewProjectionMatrix;
uniform mat4 osg_ModelViewMatrix;
uniform mat4 osg_ProjectionMatrix;
uniform mat3 osg_NormalMatrix;

out vec3 view_Vertex;
out vec3 view_Normal;
out vec3 view_Tangent;
out vec3 view_Binormal;
out vec3 world_Normal;
out vec2 texture_Coord;

uniform vec4 light_Positions[3];

out vec3 view_Light_Positions[3];

out vec4 model_Vertex;

void main() {
   	view_Normal = normalize(osg_NormalMatrix * osg_Normal);
   	view_Tangent = normalize(osg_NormalMatrix * osg_Tangent);
   	view_Binormal = normalize(osg_NormalMatrix * osg_Binormal);
	vec4 tmp = osg_ModelViewMatrix * osg_Vertex;
	view_Vertex = vec3(tmp.xyz / tmp.w);
	
	world_Normal = osg_Normal;
	
	model_Vertex = osg_Vertex;
	
	for(int i = 0; i < 3; i++) {
		view_Light_Positions[i] = vec3(osg_ModelViewMatrix * light_Positions[i]);
	}
	
	texture_Coord = osg_MultiTexCoord0;
	
	gl_Position = osg_ModelViewProjectionMatrix * osg_Vertex;
}

