#version 420

in vec3 model_Vertex;
in vec3 light_Vertex;
in vec2 texture_Coord;

uniform sampler3D light_DepthMaps[3];
uniform sampler3D light_ColorMaps[3];
uniform sampler3D light_NormalMaps[3];
out vec4 fragmentColor;

#define EXTRACT_DEPTH(cc)	((cc).b + (cc).g / 256.0 + (cc).r / (256.0 * 256.0) + (cc).a / (256.0 * 256.0 * 256.0))
#define GRAYSCALE_DEPTH(depth)	(vec4(vec3(pow((depth),20.0)),1.0))

vec3 mapCube3D(in vec3 d) {
	int face = 0;
	float s = 0.0;
	float t = 0.0;
	
	vec3 absd = abs(d);
	vec3 signd = sign(d);
        float sc = 0.0;
        float tc = 0.0;
        float ma = 0.0;

        if (absd.x >= absd.y && absd.x >= absd.z) {
                sc = signd.x * d.z;
                tc = d.y;
                ma = absd.x;
                face = d.x > 0.0 ? 0 : 1;
        }

        if (absd.y >= absd.x && absd.y >= absd.z) {
                sc = -d.x;
                tc = -signd.y * d.z;
                ma = absd.y;
                face = d.y > 0.0 ? 2 : 3;
        }

        if (absd.z >= absd.x && absd.z >= absd.y) {
                sc = -signd.z * d.x;
                tc = d.y;
                ma = absd.z;
                face = d.z > 0.0 ? 4 : 5;
        }

        if (ma == 0.0) {
                s = 0.0;
                t = 0.0;
        } else {
                s = 0.5 * (sc / ma + 1.0);
                t = 0.5 * (tc / ma + 1.0);
        }
        
	return vec3(s, t, face/5.0);
}

void main() {
	//fragmentColor = vec4(texture(light_DepthMaps[0], model_Vertex).xyz, 1.0);
	//fragmentColor = ((texture(light_DepthMaps[0], model_Vertex)));
	fragmentColor = vec4(texture(light_NormalMaps[0], mapCube3D(light_Vertex)));
	//fragmentColor = GRAYSCALE_DEPTH(EXTRACT_DEPTH(texture(light_DepthMaps[0], model_Vertex)));
}

