#version 420

in vec4 osg_Vertex;
in vec2 osg_MultiTexCoord0;

uniform mat4 osg_ModelViewProjectionMatrix;
uniform mat4 light_ModelViewMatrices[3];

out vec3 model_Vertex;
out vec3 light_Vertex;
out vec2 texture_Coord;

void main() {
	model_Vertex = osg_Vertex.xyz / osg_Vertex.w;
	mat4 lv = light_ModelViewMatrices[0];
	lv[3] = vec4(0.0, 0.0, 0.0, 1.0);
	vec4 tmp = lv * osg_Vertex;
	light_Vertex = tmp.xyz / tmp.w;
	texture_Coord = osg_MultiTexCoord0;
	gl_Position = osg_ModelViewProjectionMatrix * osg_Vertex;
}

