#version 420

in vec4 model_Vertex;
in vec3 world_Normal;

uniform vec3 volume_Min;
uniform vec3 volume_Max;
uniform int volume_Size;

uniform sampler3D volume_Debug[3];
uniform sampler3D volume_EncodedDebug[3];
uniform sampler3D volume_Geometry;

uniform bool config_useIndirectLightning;
uniform float config_lpvRenderFactor;

out vec4 fragmentColor;

#define PI			(3.1415)
vec4 constructSHClampedCosineLobeAroundDirection(in vec3 direction) {
	/*const float sqrtPi = sqrt(PI);
	const float sqrtPiOver2 = 0.5 * sqrtPi;
	const float sqrtPiOverSqrt3 = sqrtPi / sqrt(3.0);
	
	return vec4(sqrtPiOver2, -sqrtPiOverSqrt3*direction.y, sqrtPiOverSqrt3*direction.z, -sqrtPiOverSqrt3*direction.x);*/
	/*return vec4(
		PI * 0.282094792,
		((2.0*PI)/3.0) * -0.4886025119 * direction.y, 
		((2.0*PI)/3.0) *  0.4886025119 * direction.z, 
		((2.0*PI)/3.0) * -0.4886025119 * direction.x
	);*/
	
	return vec4(
			0.5, -0.75 * direction.y, 0.75 * direction.z, -0.75 * direction.x
		);
}

vec3 lookupVolume(in vec3 pos, in vec3 normal) {
	
	vec3 gridSize = (volume_Max - volume_Min) / volume_Size;
	vec3 gridPos = (pos - volume_Min) / gridSize;
	
	gridPos.x = int(gridPos.x);
	gridPos.y = int(gridPos.y);
	gridPos.z = int(gridPos.z);
	
	ivec3 gp = ivec3(gridPos);
	
	vec3 tc = gridPos / volume_Size;
	
	
	if(tc.x < 0.0 || tc.x > 1.0 ||
			tc.y < 0.0 || tc.y > 1.0 ||
			tc.z < 0.0 || tc.z > 1.0) {
		return vec3(0.0, 0.0, 0.0);
	} else {
		vec4 surfSH = constructSHClampedCosineLobeAroundDirection(normal);
		
		vec4 lpvRed = texelFetch(volume_Debug[0], gp, 0);
		vec4 lpvGreen = texelFetch(volume_Debug[1], gp, 0);
		vec4 lpvBlue = texelFetch(volume_Debug[2], gp, 0);
		
		// Use these so that OSG/OpenGL is forced to actually bind the 
		// encoded textures. Otherwise they won't show up in gDEBugger. 
		vec4 lpvRedE = texelFetch(volume_EncodedDebug[0], gp, 0);
		vec4 lpvGreenE = texelFetch(volume_EncodedDebug[1], gp, 0);
		vec4 lpvBlueE = texelFetch(volume_EncodedDebug[2], gp, 0);
		
		vec3 color = vec3(
				max(0.0f, dot(surfSH, lpvRed)), 
				max(0.0f, dot(surfSH, lpvGreen)), 
				max(0.0f, dot(surfSH, lpvBlue))
			);
		//color = texture(volume_Geometry, tc).rgb;
		return color;
	}
}

void main() {
	
	vec3 output = vec3(0.0, 0.0, 0.0);
	if(config_useIndirectLightning) {
		output = config_lpvRenderFactor * lookupVolume(model_Vertex.xyz / model_Vertex.w, normalize(world_Normal));
	}
	
	fragmentColor = vec4(output, 1.0);
}

