#version 420

in vec4 osg_Vertex;
in vec3 osg_Normal;

uniform mat4 osg_ModelViewProjectionMatrix;

uniform vec3 volume_Min;
uniform vec3 volume_Max;
uniform int volume_Size;

uniform int config_debugMode;

out vec3 world_Normal;
out vec4 model_Vertex;

void main() {
	world_Normal = osg_Normal;
	
	vec4 drawOffset = vec4(0.0, 0.0, 0.0, 0.0);
	model_Vertex = osg_Vertex;
	/*if(config_debugMode == 1) {
		vec3 gridSize = (volume_Max - volume_Min) / volume_Size;
		drawOffset = vec4(0.5 * gridSize, 0.0);
	}*/
	gl_Position = osg_ModelViewProjectionMatrix * (osg_Vertex + drawOffset);
}
