/*
 * CalculateBoundingBoxVisitor.cpp
 *
 *  Created on: Mar 30, 2012
 *      Author: dt07jo1
 */

#include "CalculateBoundingBoxVisitor.h"
#include <cstdio>
#include <cmath>

CalculateBoundingBoxVisitor::CalculateBoundingBoxVisitor() : NodeVisitor(NodeVisitor::TRAVERSE_ALL_CHILDREN) {
	transformMatrix.makeIdentity();
}

CalculateBoundingBoxVisitor::~CalculateBoundingBoxVisitor() {}

void CalculateBoundingBoxVisitor::apply(osg::Geode &geode) {
	osg::BoundingBox bbox;

	for (unsigned int i = 0; i < geode.getNumDrawables(); ++i) {
		osg::BoundingBox dbb = geode.getDrawable(i)->getBound();
		bbox.expandBy(geode.getDrawable(i)->getBound());
	}


	osg::BoundingBox bboxTrans;

	if(bbox.valid()) {
		for (unsigned int i = 0; i < 8; ++i) {
			osg::Vec3 xvec = bbox.corner(i) * transformMatrix;
			bboxTrans.expandBy(xvec);
		}
	}

	boundingBox.expandBy(bboxTrans);

	traverse(geode);

}

void CalculateBoundingBoxVisitor::apply(osg::MatrixTransform &node) {
	transformMatrix *= node.getMatrix();
	traverse(node);
}

void CalculateBoundingBoxVisitor::apply(osg::Billboard &node) {
	traverse(node);
}

osg::BoundingBox CalculateBoundingBoxVisitor::getBoundBox() {
	printf("BB: (%f, %f, %f) -> (%f, %f, %f)\n", boundingBox._min.x(), boundingBox._min.y(), boundingBox._min.z(), boundingBox._max.x(), boundingBox._max.y(), boundingBox._max.z());
	/*osg::Vec3f delta = boundingBox._max - boundingBox._min;
	osg::BoundingBox bb;
	bb._min = boundingBox._min - delta * 0.01f;
	bb._max = boundingBox._max + delta * 0.01f;
	return bb;*/

	osg::Vec3f delta = boundingBox._max - boundingBox._min;
	osg::Vec3f center = boundingBox.center();
	float maxExtent = std::max(std::max(
			std::abs(delta.x()),
			std::abs(delta.y())),
			std::abs(delta.z())) / 2.0f;
	osg::BoundingBox bb;
	const float multiplier = 1.10f;
	osg::Vec3f d(maxExtent * multiplier, maxExtent * multiplier, maxExtent * multiplier);
	bb._min = center - d;
	bb._max = center + d;
	return bb;
}
