/*
 * CalculateBoundingBoxVisitor.h
 *
 *  Created on: Mar 30, 2012
 *      Author: dt07jo1
 */

#ifndef CALCULATEBOUNDINGBOXVISITOR_H_
#define CALCULATEBOUNDINGBOXVISITOR_H_

#include <osg/NodeVisitor>
#include <osg/BoundingBox>
#include <osg/BoundingSphere>
#include <osg/MatrixTransform>
#include <osg/Billboard>

/*
 * Based on original code by Gordon Tomlinson retrieved from:
 * http://www.vis-sim.com/osg/code/osgcode_bbox1.htm
 */
class CalculateBoundingBoxVisitor: public osg::NodeVisitor {
public:
	CalculateBoundingBoxVisitor();
	virtual ~CalculateBoundingBoxVisitor();

	virtual void apply(osg::Geode &geode);
	virtual void apply(osg::MatrixTransform &node);
	virtual void apply(osg::Billboard &node);

	osg::BoundingBox getBoundBox();

protected:

	osg::BoundingBox boundingBox;
	osg::Matrix transformMatrix;
};

#endif /* CALCULATEBOUNDINGBOXVISITOR_H_ */
