#ifndef CALLBACKUTILS_H_
#define CALLBACKUTILS_H_

#include <osg/NodeCallback>
#include <osg/Uniform>
#include <osg/NodeVisitor>
#include <osg/Geode>
#include <osg/Camera>
#include <osg/Node>
#include <osgCompute/Memory>

#include "cuda/CommonStructs.h"
#include "SceneConfig.h"


class BeforePrerenderCallback : public osg::Camera::Camera::DrawCallback {
public:
	BeforePrerenderCallback();
	virtual void operator()(osg::RenderInfo& renderInfo) const;
};

class AfterPrerenderCallback : public osg::Camera::Camera::DrawCallback {
public:
	AfterPrerenderCallback();
	virtual void operator()(osg::RenderInfo& renderInfo) const;
};

class CopyLightPositionToUniformCallback : public osg::NodeCallback {
public:
	CopyLightPositionToUniformCallback(osg::Uniform* uniform, int i);
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	osg::Uniform* uniform;
	int i;
};

class CopyLightColorToUniformCallback : public osg::NodeCallback {
public:
	CopyLightColorToUniformCallback(osg::Uniform* uniform, int i);
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	osg::Uniform* uniform;
	int i;
};

class CopyLightViewToUniformCallback : public osg::NodeCallback {
public:
	CopyLightViewToUniformCallback(osg::Uniform* uniform, int i);
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	osg::Uniform* uniform;
	int i;
};

class CopyLightViewToCudaMemoryCallback : public osg::NodeCallback {
public:
	CopyLightViewToCudaMemoryCallback(Transform* transform);
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	Transform* transform;
};

class UpdateCameraCallback : public osg::NodeCallback {
public:
	UpdateCameraCallback(osg::Camera *camera, int face);
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	osg::Camera *camera;
	int face;
};

class FlagRemover : public osg::NodeVisitor {
public:
	FlagRemover();
	virtual void apply(osg::Geode &node);
};

class LightAnimationCallback : public osg::NodeCallback, public SceneConfigurable {
public:
	LightAnimationCallback();
	virtual void operator() (osg::Node *node, osg::NodeVisitor *nv);
private:
	double lastFrame;
	double simulationTime;
};

#endif /* CALLBACKUTILS_H_ */
