#ifndef DEFINES_H_
#define DEFINES_H_

#include <cstdio>

#define SCENE_SPONZA
//#define SCENE_DEBUG
#define DEBUG_LIGHTS

#define RSM_CAMERA_NEAR (1.0f)
#define RSM_CAMERA_FAR (10000.0f)
#define RSM_CAMERA_FOV (90.0f)
#define RSM_CAMERA_ASPECT (1.0f)

#define VIEW_CAMERA_NEAR (1.0f)
#define VIEW_CAMERA_FAR (10000.0f)

#define RSM_RESOLUTION (1024)
#define RSM_SAMPLE_RESOLUTION (256)
#define LPV_SIZE (32)

#define LIGHT_MOVEMENT_SPEED (100.0f)
#define LIGHT_VARIANCE_Z (500.0f)
#define LIGHT_VARIANCE_Y (1000.0f)
#define LIGHT_DISTANCE_X (500.0f)
#define LIGHT_DISTANCE_Y (000.0f)
#define LIGHT_DISTANCE_Z (000.0f)
#define LIGHT_CENTER_X (000.0f)
#define LIGHT_CENTER_Y (000.0f)
#define LIGHT_CENTER_Z (1800.0f)
#define LIGHT_SPHERE_SIZE (20.0f)
//#define LIGHT_COLOR (osg::Vec4(0.6, 0.6, 0.6, 1.0f))
#define LIGHT_COLOR (osg::Vec4(0.6f, 0.6f, 0.6f, 1.0f))

#define TEXTURE_ID_GV (7)
#define TEXTURE_ID_LPV_START (TEXTURE_ID_GV+1)
#define TEXTURE_ID_RSM_START (TEXTURE_ID_LPV_START+9)

#define VIRTUAL_SCREEN_WIDTH (1600)
#define VIRTUAL_SCREEN_HEIGHT (1200)
#define HUD_WIDTH (300.0f)
#define HUD_HEIGHT (600.0f)

#define RENDER_MERGED_BUFFER


#define DEBUG_FLOW (1)


#define debug_flow_print(fmt, ...) \
        do { if (DEBUG_FLOW) fprintf(stderr, "%s:%d:%s(): " fmt, __FILE__, \
                                __LINE__, __func__, __VA_ARGS__); } while (0)

#endif /* DEFINES_H_ */
