#ifndef OSGGA_FPSMANIPULATOR
#define OSGGA_FPSMANIPULATOR 1

#include <osgGA/StandardManipulator>
#include <osg/Quat>

namespace osgGA {

class FPSManipulator: public StandardManipulator {
public:

	FPSManipulator();

	virtual void setByMatrix(const osg::Matrixd& matrix);
	virtual void setByInverseMatrix(const osg::Matrixd& matrix);
	virtual osg::Matrixd getMatrix() const;
	virtual osg::Matrixd getInverseMatrix() const;

	virtual void setTransformation(const osg::Vec3d& eye,
			const osg::Quat& rotation);
	virtual void setTransformation(const osg::Vec3d& eye,
			const osg::Vec3d& center, const osg::Vec3d& up);
	virtual void getTransformation(osg::Vec3d& eye, osg::Quat& rotation) const;
	virtual void getTransformation(osg::Vec3d& eye, osg::Vec3d& center,
			osg::Vec3d& up) const;

	virtual void setMouseSense(double sx, double sy);
	virtual void setMoveSense(double forward, double sideways);
	virtual void setShiftFactor(double factor);

protected:
	void flushMouseEventStack();

	virtual bool handle(const GUIEventAdapter& ea, GUIActionAdapter& us);
	virtual bool handleFrame(const GUIEventAdapter& ea, GUIActionAdapter& us);
	virtual bool handleMouseMove(const GUIEventAdapter& ea,
			GUIActionAdapter& us);
	virtual bool handleMouseDrag(const GUIEventAdapter& ea,
			GUIActionAdapter& us);

	virtual bool handleKeyDown(const osgGA::GUIEventAdapter& ea,
			osgGA::GUIActionAdapter& us);
	virtual bool handleKeyUp(const osgGA::GUIEventAdapter& ea,
			osgGA::GUIActionAdapter& us);

	virtual bool performMouseDeltaMovement(const float dx, const float dy);
	virtual bool performKeyMovement(double dt);
	virtual bool performMovement();

	void moveForward(const double distance);
	void moveForward(const osg::Quat& rotation, const double distance);
	void moveRight(const double distance);

	osg::Vec3d _eye;
	osg::Quat _rotation;

	double mouseSenseX;
	double mouseSenseY;
	double moveSenseForward;
	double moveSenseSideways;
	double shiftFactor;

	bool keyW;
	bool keyA;
	bool keyS;
	bool keyD;
	bool keyShift;
};

}

#endif
