/*
 * FrameTimeMonitor.cpp
 *
 *  Created on: Mar 22, 2012
 *      Author: dt07jo1
 */

#include "FrameTimeMonitor.h"
#include "TimeMonitor.h"
#include <iostream>
#include <sstream>

FrameTimeMonitor::FrameTimeMonitor() :
		lastFrame(0.0),
		frameCount(-1),
		fpsValueText(0) {}

FrameTimeMonitor::~FrameTimeMonitor() {}


void FrameTimeMonitor::setFpsValueText(osgText::Text* fpsValueText) {
	this->fpsValueText = fpsValueText;
}

void FrameTimeMonitor::addFrame(double time) {
	if(frameCount == -1) {
		lastFrame = time;
		frameCount++;
	} else {
		frameTimes[frameCount % 5] = time - lastFrame;
		lastFrame = time;
		frameCount++;
		onUpdate();
	}
}

void FrameTimeMonitor::onUpdate() {
	if(frameCount > 0) {
		double frameTimeSum = 0.0;
		for(int i = 0; i < std::min(5, frameCount); i++) {
			frameTimeSum += frameTimes[i];
		}

		double fps = std::min(5, frameCount) / frameTimeSum;
		std::stringstream ss;
		ss << fps << std::endl << frameCount;
		fpsValueText->setText(ss.str());
	}
}

bool FrameTimeMonitor::handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& aa, osg::Object* obj, osg::NodeVisitor* nv) {
	if(ea.getEventType() == osgGA::GUIEventAdapter::FRAME) {
		if(frameCount != -1) {
			TimeMonitor::instance()->toc(TimeMonitor::Frame);
		}
		TimeMonitor::instance()->tic(TimeMonitor::Frame);

		addFrame(ea.getTime());

		if(frameCount == 500) {
			TimeMonitor::instance()->dump("500 frames");
		}
	}
	return false;
}
