/*
 * FrameTimeMonitor.h
 *
 *  Created on: Mar 22, 2012
 *      Author: dt07jo1
 */

#ifndef FRAMETIMEMONITOR_H_
#define FRAMETIMEMONITOR_H_

#include <osgGA/GUIEventHandler>
#include <osgText/Text>

class FrameTimeMonitor : public osgGA::GUIEventHandler {
public:
	FrameTimeMonitor();
	virtual ~FrameTimeMonitor();

	bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& aa, osg::Object* obj, osg::NodeVisitor* nv);
	void setFpsValueText(osgText::Text* fpsValueText);

private:
	void addFrame(double time);
	void onUpdate();

	double lastFrame;
	double frameTimes[5];
	int frameCount;

	osgText::Text* fpsValueText;
};

#endif /* FRAMETIMEMONITOR_H_ */
