#ifndef LIGHTPRERENDERSETUP_H_
#define LIGHTPRERENDERSETUP_H_

#include <osg/NodeVisitor>
#include <osg/LightSource>
#include <osg/Node>
#include <osg/Group>
#include <osg/StateSet>

#include <vector>

#include "data/LightPropagationVolume.h"
#include "SceneConfig.h"


class LightPrerenderSetup : public osg::NodeVisitor {
public:
	LightPrerenderSetup(SceneConfig* config);
	virtual void apply(osg::LightSource &node);
	void setup(osg::Node* scene, osg::Group* root, osg::StateSet* ss);

	data::LightPropagationVolume* getLPV() const;

private:
	SceneConfig* config;
	std::vector<osg::LightSource*> lightSources;

	data::LightPropagationVolume* lpv;
};

#endif /* LIGHTPRERENDERSETUP_H_ */
