#ifndef SCENECONFIG_H_
#define SCENECONFIG_H_

#include <osg/Uniform>
#include <osgGA/GUIEventHandler>
#include <osgText/Text>

#include <sstream>


class SceneConfig : public osgGA::GUIEventHandler {
public:
	enum LightAnimationType {
		ANIMATE_STATIC, ANIMATE_ZAXIS, ANIMATE_ROTATE, ANIMATE_YAXIS,
		ANIMATE_LAST
	};

	enum HudSection {
		SECTION_GENERAL, SECTION_LIGHTS, SECTION_LAST
	};

	enum DebugMode {
		DEBUG_INJECTION, DEBUG_GEOMETRY, DEBUG_PROPAGATION, DEBUG_LAST
	};


	SceneConfig();

	void setLpvPropagationSteps(int lpvPropagationSteps);
	int getLpvPropagationSteps() const;

	void setLpvPropagationFactor(float lpvPropagationFactor);
	float getLpvPropagationFactor() const;

	void setLpvInjectionFactor(float lpvInjectionFactor);
	float getLpvInjectionFactor() const;

	void setLpvRenderFactor(float lpvRenderFactor);
	float getLpvRenderFactor() const;

	void setGvOcclusionFactor(float gvOcclusionFactor);
	float getGvOcclusionFactor() const;

	void setGvInjectionFactor(float gvInjectionFactor);
	float getGvInjectionFactor() const;

	void setLpvSampleLevel(int level);
	int getLpvSampleLevel() const;

	void setUseDirectLightning(bool useDirectLightning);
	bool getUseDirectLightning() const;

	void setUseIndirectLightning(bool useIndirectLightning);
	bool getUseIndirectLightning() const;

	void setUseDynamicLpvs(bool useDynamicLpvs);
	bool getUseDynamicLpvs() const;

	void setUseDiffuseMaps(bool useDiffuseMaps);
	bool getUseDiffuseMaps() const;

	void setUseBumpMaps(bool useBumpMaps);
	bool getUseBumpMaps() const;

	void setUseShadowMaps(bool useShadowMaps);
	bool getUseShadowMaps() const;

	void setUseIndirectOcclusion(bool useIndirectOcclusion);
	bool getUseIndirectOcclusion() const;

	void setUseDebugGrid(bool useDebugGrid);
	bool getUseDebugGrid() const;

	void setUseDebugSH(bool useDebugSH);
	bool getUseDebugSH() const;


	void setLightAnimationSpeed(float lightAnimationSpeed);
	float getLightAnimationSpeed() const;

	void setUseAnimatedLight(bool useAnimatedLight);
	bool getUseAnimatedLight() const;

	void setLightAnimationType(LightAnimationType lightAnimationType);
	LightAnimationType getLightAnimationType() const;

	void setLightCenter(const osg::Vec3& lightCenter);
	osg::Vec3 getLightCenter() const;

	void setDebugMode(DebugMode debugMode);
	DebugMode getDebugMode() const;


	void changeSection();

	void install(osg::StateSet* ss);

	int getStateId() const;
	int getDumpId() const;
	void requestDump();

	bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& aa, osg::Object* obj, osg::NodeVisitor* nv);

	void setHudOptionsText(osgText::Text* optionsText);
	void setHudValuesText(osgText::Text* valuesText);

	void setDebugNode(osg::Node* debugNode);
	void setDebugSHNode(osg::Node* debugSHNode);

private:
	SceneConfig(const SceneConfig&);
	SceneConfig& operator=(const SceneConfig&);

	void onChangedState();
	void updateHudOptionsText();
	void updateHudValuesText();

	static const float scaleFactor;
	int stateId;
	int dumpId;

	HudSection currentSection;
	osgText::Text* optionsText;
	osgText::Text* valuesText;

	osg::Node* debugNode;
	osg::Node* debugSHNode;

	struct {
		int lpvPropagationSteps;
		float lpvPropagationFactor;
		float lpvInjectionFactor;
		float lpvRenderFactor;
		float gvOcclusionFactor;
		float gvInjectionFactor;
		int lpvSampleLevel;

		float lightAnimationSpeed;
		bool useAnimatedLight;
		LightAnimationType lightAnimationType;
		osg::Vec3f lightCenter;

		DebugMode debugMode;

		bool useDirectLightning;
		bool useIndirectLightning;
		bool useDynamicLpvs;
		bool useDiffuseMaps;
		bool useBumpMaps;
		bool useShadowMaps;
		bool useIndirectOcclusion;
		bool useDebugGrid;
		bool useDebugSH;
	} config;

	struct {
		osg::ref_ptr<osg::Uniform> lpvPropagationSteps;
		osg::ref_ptr<osg::Uniform> lpvPropagationFactor;
		osg::ref_ptr<osg::Uniform> lpvInjectionFactor;
		osg::ref_ptr<osg::Uniform> lpvRenderFactor;
		osg::ref_ptr<osg::Uniform> gvOcclusionFactor;
		osg::ref_ptr<osg::Uniform> gvInjectionFactor;
		osg::ref_ptr<osg::Uniform> debugMode;

		osg::ref_ptr<osg::Uniform> useDirectLightning;
		osg::ref_ptr<osg::Uniform> useIndirectLightning;
		osg::ref_ptr<osg::Uniform> useDynamicLpvs;
		osg::ref_ptr<osg::Uniform> useDiffuseMaps;
		osg::ref_ptr<osg::Uniform> useBumpMaps;
		osg::ref_ptr<osg::Uniform> useShadowMaps;
		osg::ref_ptr<osg::Uniform> useIndirectOcclusion;
		osg::ref_ptr<osg::Uniform> useDebugGrid;
		osg::ref_ptr<osg::Uniform> useDebugSH;

	} uniform;
};

class SceneConfigurable {
public:
	SceneConfigurable();

	void setConfig(SceneConfig* config);
	SceneConfig* getConfig() const;
	bool hasChangedState() const;
	void updateState();

	bool hasRequestedDump() const;
	void updateDump();
	std::string getDumpId() const;
protected:
	SceneConfig* config;
	int lastStateId;
	int lastDumpId;
};


#endif /* SCENECONFIG_H_ */
