#include "TangentSpaceVisitor.h"
#include <set>
#include <osgUtil/TangentSpaceGenerator>

TangentSpaceVisitor::TangentSpaceVisitor(int tangentIndex, int binormalIndex) :
		osg::NodeVisitor(NODE_VISITOR, TRAVERSE_ALL_CHILDREN),
		tangentIndex(tangentIndex),
		binormalIndex(binormalIndex) {}

void TangentSpaceVisitor::apply(osg::Geode &node) {
	unsigned int drawables = node.getNumDrawables();
	for (unsigned int i = 0; i < drawables; ++i) {
		osg::ref_ptr<osgUtil::TangentSpaceGenerator> tsg =
				new osgUtil::TangentSpaceGenerator;
		osg::Drawable* d = node.getDrawable(i);
		osg::Geometry* g = d->asGeometry();
		tsg->generate(g, 0);
		g->setVertexAttribData(
				tangentIndex,
				osg::Geometry::ArrayData(tsg->getTangentArray(),
						osg::Geometry::BIND_PER_VERTEX, GL_FALSE));
		g->setVertexAttribData(
				binormalIndex,
				osg::Geometry::ArrayData(tsg->getBinormalArray(),
						osg::Geometry::BIND_PER_VERTEX, GL_FALSE));
	}
}
